/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.base.AbstractZawaLand;

public class MessagePlayAnimation
implements IMessage {
    private int entityId;
    private int animation;
    private boolean forced;

    public MessagePlayAnimation() {
    }

    public MessagePlayAnimation(Entity entity, int animation) {
        this.entityId = entity.func_145782_y();
        this.animation = animation;
        this.forced = false;
    }

    public MessagePlayAnimation(Entity entity, int animation, boolean forced) {
        this(entity, animation);
        this.forced = forced;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.animation = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.forced = ByteBufUtils.readVarInt((ByteBuf)buf, (int)1) != 0;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.animation, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(this.forced ? 1 : 0), (int)1);
    }

    public static class Handler
    implements IMessageHandler<MessagePlayAnimation, IMessage> {
        public IMessage onMessage(MessagePlayAnimation message, MessageContext ctx) {
            AbstractZawaLand e = (AbstractZawaLand)ZAWAMain.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.entityId);
            if (e != null) {
                if (message.forced) {
                    e.getAnimator().forcePlay(message.animation);
                } else {
                    e.getAnimator().play(message.animation);
                }
            }
            return null;
        }
    }
}

