/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import org.zawamod.gui.element.GuiScrollingListItems;
import org.zawamod.init.ZAWAItems;

public class GuiExplorationGuide
extends GuiScreen {
    Minecraft field_146297_k = Minecraft.func_71410_x();
    public static final ResourceLocation MAIN = new ResourceLocation("zawa", "textures/gui/exploration/exploration_guide.png");
    private List<Biome> biomes;
    private Biome selectedBiome;
    private GuiScrollingList ents;
    private GuiScrollingListItems spawns;
    private List<ItemStack> spawnItems;
    private int mouseX;
    private int mouseY;
    private EntityPlayer player;
    private Map<ItemStack, Data> dataMap = new HashMap<ItemStack, Data>();

    public GuiExplorationGuide(EntityPlayer player) {
        this.player = player;
        this.selectedBiome = player.field_70170_p.func_180494_b(new BlockPos((Entity)player));
    }

    public void func_73866_w_() {
        if (this.player == null) {
            return;
        }
        this.biomes = new ArrayList<Biome>();
        this.spawnItems = new ArrayList<ItemStack>();
        ForgeRegistries.BIOMES.forEach(this.biomes::add);
        this.biomes.sort((c, c1) -> c.func_185359_l().compareTo(c1.func_185359_l()));
        for (EnumCreatureType type : EnumCreatureType.values()) {
            for (Biome.SpawnListEntry e : this.selectedBiome.func_76747_a(type)) {
                if (!ZAWAItems.SPAWN_EGG_DATA.containsKey(e.field_76300_b) || this.spawnItems.contains(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b))) continue;
                this.spawnItems.add(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b));
                this.dataMap.put(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b), new Data(e.field_76292_a, e.field_76301_c, e.field_76299_d));
            }
        }
        this.field_146292_n.clear();
        this.ents = new GuiScrollingList(this.field_146297_k, 103, this.field_146295_m, this.field_146295_m / 2 - 107, this.field_146295_m / 2 + 85, this.field_146294_l / 2 - 209, 14, this.field_146294_l, this.field_146295_m){

            protected boolean isSelected(int index) {
                return ((Biome)GuiExplorationGuide.this.biomes.get(index)).equals(GuiExplorationGuide.this.selectedBiome);
            }

            protected int getSize() {
                return GuiExplorationGuide.this.biomes.size();
            }

            protected void elementClicked(int index, boolean doubleClick) {
                GuiExplorationGuide.this.selectedBiome = (Biome)GuiExplorationGuide.this.biomes.get(index);
                GuiExplorationGuide.this.spawnItems.clear();
                GuiExplorationGuide.this.dataMap.clear();
                if (GuiExplorationGuide.this.selectedBiome != null) {
                    for (EnumCreatureType type : EnumCreatureType.values()) {
                        for (Biome.SpawnListEntry e : GuiExplorationGuide.this.selectedBiome.func_76747_a(type)) {
                            if (!ZAWAItems.SPAWN_EGG_DATA.containsKey(e.field_76300_b) || GuiExplorationGuide.this.spawnItems.contains(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b))) continue;
                            GuiExplorationGuide.this.spawnItems.add(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b));
                            GuiExplorationGuide.this.dataMap.put(ZAWAItems.SPAWN_EGG_DATA.get(e.field_76300_b), new Data(e.field_76292_a, e.field_76301_c, e.field_76299_d));
                        }
                    }
                }
            }

            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (this.isSelected(slotIdx)) {
                    GuiExplorationGuide.this.field_146289_q.func_78276_b(((Biome)GuiExplorationGuide.this.biomes.get(slotIdx)).func_185359_l(), this.screenWidth / 2 - 201, slotTop + 1, 14605959);
                } else {
                    GuiExplorationGuide.this.field_146289_q.func_78276_b(((Biome)GuiExplorationGuide.this.biomes.get(slotIdx)).func_185359_l(), this.screenWidth / 2 - 201, slotTop + 1, 14737628);
                }
            }

            protected void drawBackground() {
            }
        };
        this.spawns = new GuiScrollingListItems(this.field_146297_k, 241, this.field_146295_m, this.field_146295_m / 2 - 70, this.field_146295_m / 2 + 56, this.field_146294_l / 2 - 54, 16, this.field_146294_l, this.field_146295_m){

            @Override
            protected boolean isSelected(int index) {
                return false;
            }

            @Override
            protected int getSize() {
                return GuiExplorationGuide.this.spawnItems.size() < 15 ? 15 : GuiExplorationGuide.this.spawnItems.size();
            }

            @Override
            protected void drawScreen(int mouseX, int mouseY) {
                super.drawScreen(mouseX, mouseY);
                this.xP = 0;
                this.yP = 0;
                this.off = 0;
            }

            @Override
            protected void elementClicked(int index, boolean doubleClick) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (this.xP == 0 && this.off == 0) {
                    this.off = slotTop;
                }
                if (slotIdx >= GuiExplorationGuide.this.spawnItems.size()) {
                    return;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                RenderHelper.func_74519_b();
                GlStateManager.func_179091_B();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179142_g();
                ItemStack stack = (ItemStack)GuiExplorationGuide.this.spawnItems.get(slotIdx);
                if (stack != null) {
                    GuiExplorationGuide.this.field_146296_j.func_180450_b(stack, (int)((float)entryRight + (float)this.xP * 15.72f - 233.5f), (int)((float)(this.top + 4 - (int)this.scrollDistance + this.headerHeight - 4) + (float)this.yP * 15.88f));
                }
                GlStateManager.func_179101_C();
                RenderHelper.func_74518_a();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179121_F();
                ++this.xP;
                if (this.xP >= 15) {
                    this.xP = 0;
                    ++this.yP;
                }
            }

            @Override
            protected void drawBackground() {
            }

            @Override
            protected int getContentHeight() {
                return super.getContentHeight();
            }
        };
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.ents.handleMouseInput(this.mouseX, this.mouseY);
        this.spawns.handleMouseInput(this.mouseX, this.mouseY);
    }

    public void func_73876_c() {
    }

    public void func_73863_a(int parWidth, int parHeight, float particle) {
        this.mouseX = parWidth;
        this.mouseY = parHeight;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        this.field_146297_k.func_110434_K().func_110577_a(MAIN);
        int offLeft = (this.field_146294_l - 450) / 2;
        int offTop = this.field_146295_m / 2 - 125 - 3;
        int topOffset = this.field_146295_m / 2;
        GuiExplorationGuide.func_146110_a((int)(offLeft - 7), (int)offTop, (float)0.0f, (float)0.0f, (int)450, (int)234, (float)450.0f, (float)234.0f);
        this.field_146289_q.func_78276_b("EXPLORATION GUIDE", offLeft + 170, offTop + 40, 8023641);
        this.field_146289_q.func_78276_b("Weight/Min/Max", offLeft + 170, offTop + 50, 0);
        super.func_73863_a(parWidth, parHeight, particle);
        this.ents.drawScreen(parWidth, parHeight, particle);
        this.spawns.drawScreen(parWidth, parHeight, particle);
        int b = this.spawns.left + this.spawns.listWidth - 7;
        int xP = 0;
        int yP = 0;
        int off = this.spawns.top + 16 - (int)this.spawns.scrollDistance + this.spawns.headerHeight;
        for (ItemStack spawnItem : this.spawnItems) {
            if (this.mouseX > (int)((float)b + (float)xP * 15.72f - 217.5f) - 16 && (float)this.mouseX < (float)((int)((float)b + (float)xP * 15.72f - 217.5f)) + 0.3f && this.mouseY > (int)((float)(off - 4) + (float)yP * 15.88f) - 13 && this.mouseY < (int)((float)(off - 4) + (float)yP * 15.88f) + 4) {
                Data d = this.dataMap.get(spawnItem);
                this.func_146279_a(spawnItem.func_82833_r().replaceAll("Spawn ", ""), this.mouseX, this.mouseY - 15);
                this.func_146279_a("" + d.chance + "/" + d.min + "/" + d.max, this.mouseX, this.mouseY);
            }
            if (++xP < 15) continue;
            xP = 0;
            ++yP;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    protected void func_146273_a(int parMouseX, int parMouseY, int parLastButtonClicked, long parTimeSinceMouseClick) {
    }

    protected void func_146284_a(GuiButton button) {
    }

    public void func_146281_b() {
        this.player = null;
    }

    public boolean func_73868_f() {
        return false;
    }

    private static class Data {
        public int chance;
        public int min;
        public int max;

        public Data(int chance, int min, int max) {
            this.chance = chance;
            this.min = min;
            this.max = max;
        }
    }
}

