/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.vehicle;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.gui.container.ContainerVehicleChest;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class ZAWABaseVehicle
extends Entity
implements IInventoryChangedListener {
    protected static final DataParameter<Float> ACCELERATION = EntityDataManager.func_187226_a(ZAWABaseVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    public float tireRotation = 0.0f;
    public float tireDirection = 0.0f;
    public int blocksToGround;
    public int blocksToGroundBack;
    public int overSpeedingTime;
    public int badEngineTime;
    public boolean badEngine;
    public boolean engineBreak;
    public ContainerVehicleChest vehicleChest;

    public ZAWABaseVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.6f, 2.3f);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return true;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.enableInventory() && this.vehicleChest != null) {
                for (int i = 0; i < this.vehicleChest.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.vehicleChest.func_70301_a(i);
                    if (itemstack.func_190926_b()) continue;
                    this.func_70099_a(itemstack, 0.0f);
                }
            }
            this.func_145779_a(this.shiftDrop().func_77973_b(), 1);
        }
        super.func_70106_y();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ACCELERATION, (Object)Float.valueOf(0.0f));
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean hasAccessableInventory() {
        return true;
    }

    public float getAcceleration() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION)).floatValue();
    }

    public void setAcceleration(float f) {
        this.field_70180_af.func_187227_b(ACCELERATION, (Object)Float.valueOf(f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setAcceleration(compound.func_74760_g("Acceleration"));
        this.setHolding(compound.func_74767_n("Holding"));
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.initVehicleChest();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 2 || j >= this.vehicleChest.func_70302_i_()) continue;
            this.vehicleChest.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.updateVehicleSlots();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Acceleration", this.getAcceleration());
        compound.func_74757_a("Holding", this.getHolding());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 2; i < this.vehicleChest.func_70302_i_(); ++i) {
            ItemStack itemstack = this.vehicleChest.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public double func_70042_X() {
        return 0.7;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.ATV, 1);
    }

    public SoundEvent getStartupSound() {
        return null;
    }

    public SoundEvent getIdleSound() {
        return ZAWASounds.JEEP_DRIVELOOP_2;
    }

    public SoundEvent getDriveSound() {
        return ZAWASounds.JEEP_DRIVELOOP;
    }

    public ItemStack shiftDrop() {
        return new ItemStack(ZAWAItems.ATV, 1);
    }

    public boolean getHolding() {
        return this.getEntityData().func_74767_n("Holding");
    }

    public void setHolding(boolean b) {
        this.getEntityData().func_74757_a("Holding", b);
    }

    public boolean enableInventory() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (this.enableInventory() && player.func_184218_aH()) {
            this.openGUI(player);
            return true;
        }
        if (this.canHoldAnimals()) {
            if (stack.func_77973_b() == ZAWAItems.NET && !this.getHolding()) {
                if (stack.func_77978_p() != null) {
                    try {
                        Entity entity2 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i("Entity")), (World)this.field_70170_p);
                        entity2.func_70020_e((NBTTagCompound)stack.func_77978_p().func_74781_a("Data"));
                        if (entity2 instanceof AbstractZawaLand && !((AbstractZawaLand)entity2).isTransportable()) {
                            if (player.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This animal cannot be transported"));
                            }
                            return false;
                        }
                        entity2.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d(entity2);
                            entity2.func_184220_m((Entity)this);
                        }
                        this.setHolding(true);
                        stack.func_77982_d(null);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    catch (Exception es) {
                        System.err.println("Entity cannot be created!");
                    }
                    stack.func_77982_d(null);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                } else if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This net has no entity use 'attack' key to capture an animal"));
                }
            } else if (player.func_70093_af() && this.func_184179_bs() == null) {
                if (this.getHolding()) {
                    this.func_184226_ay();
                    this.setHolding(false);
                    return true;
                }
                this.func_70106_y();
                return true;
            }
        } else if (player.func_70093_af()) {
            this.func_70106_y();
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184219_q((Entity)player) && !player.func_70093_af() && stack.func_77973_b() != ZAWAItems.NET) {
            this.func_184185_a(this.getStartupSound(), 1.0f, 1.0f);
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float setSpeed() {
        return 0.05f;
    }

    public float setReverseSpeed() {
        return 0.2f;
    }

    public float setTurnSpeed() {
        return 0.6f;
    }

    public float setWaterSpeed() {
        return 0.1f;
    }

    public float setWaterReverseSpeed() {
        return -0.05f;
    }

    public boolean canHoldAnimals() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184179_bs() != passenger) {
            float calcX = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) + 100.3f));
            float calcZ = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) + 100.3f));
            passenger.func_70107_b(this.field_70165_t - (double)calcX - (double)(calcX * 1.1f), this.field_70163_u + (double)0.8f, this.field_70161_v - (double)calcZ - (double)(calcZ * 1.1f));
        }
        if (this.func_184179_bs() == passenger) {
            float angle = 0.0174533f * this.field_70177_z + 105.0f;
            if (this.blocksToGround == 1) {
                passenger.func_70107_b(this.field_70165_t + (double)(0.6f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle + 20.0)))), this.field_70163_u - 0.2, this.field_70161_v + (double)(0.6f * MathHelper.func_76134_b((float)(angle + 20.0f))));
            } else if (this.blocksToGround == 2) {
                passenger.func_70107_b(this.field_70165_t + (double)(1.1f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle + (double)20.2f)))), this.field_70163_u - 0.9, this.field_70161_v + (double)(1.1f * MathHelper.func_76134_b((float)(angle + 20.2f))));
            } else if (this.blocksToGroundBack == 1) {
                passenger.func_70107_b(this.field_70165_t + (double)(0.7f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle + (double)5.6f)))), this.field_70163_u + 0.0, this.field_70161_v + (double)(0.7f * MathHelper.func_76134_b((float)(angle + 5.6f))));
            } else if (this.blocksToGroundBack == 2) {
                passenger.func_70107_b(this.field_70165_t + (double)(1.1f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle - (double)19.9f)))), this.field_70163_u - 0.8, this.field_70161_v + (double)(1.1f * MathHelper.func_76134_b((float)(angle - 19.9f))));
            } else {
                passenger.func_70107_b(this.field_70165_t + (double)(0.4f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))), this.field_70163_u + 0.45, this.field_70161_v + (double)(0.4f * MathHelper.func_76134_b((float)angle)));
            }
        }
        if (this.func_184179_bs() != passenger) {
            return;
        }
        if (!(passenger instanceof EntityPlayer)) {
            return;
        }
    }

    public boolean canBeSteered() {
        boolean flag = false;
        for (Entity e : this.func_184188_bt()) {
            if (!(e instanceof EntityPlayer)) continue;
            flag = true;
        }
        return flag && this.func_184179_bs() instanceof EntityPlayer;
    }

    public void func_70071_h_() {
        int k;
        int j;
        int i;
        BlockPos blockpos;
        IBlockState iblockstate;
        if (this.getAcceleration() >= 1.0f && (iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            float angle = 0.0174533f * this.field_70177_z + 35.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(2.1f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))), this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + (double)(2.1f * MathHelper.func_76134_b((float)angle)), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            angle = 0.0174533f * this.field_70177_z + 40.3f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(2.1f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))), this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + (double)(2.1f * MathHelper.func_76134_b((float)angle)), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        super.func_70071_h_();
    }

    public float getMaxAcceleration() {
        return 7.1f;
    }

    public void func_70030_z() {
        float forward = 0.0f;
        if (this.func_184207_aI() && this.canBeSteered() && this.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase driver = (EntityLivingBase)this.func_184179_bs();
            if (this.field_70170_p.field_72995_K) {
                if (driver.field_191988_bg != 0.0f && this.getAcceleration() < this.getMaxAcceleration() && this.getAcceleration() > -this.getMaxAcceleration()) {
                    this.setAcceleration(this.getAcceleration() + driver.field_191988_bg * 0.1f);
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && driver.field_191988_bg == 0.0f) {
                    if (this.getAcceleration() > 0.0f) {
                        this.setAcceleration((float)((double)this.getAcceleration() - Math.abs((double)this.getAcceleration() / Math.pow(this.getAcceleration(), 2.0))));
                    } else if (this.getAcceleration() < 0.0f) {
                        this.setAcceleration(this.getAcceleration() + Math.abs(this.getAcceleration() * 0.7f));
                    } else {
                        this.setAcceleration(0.0f);
                    }
                }
            }
            this.field_70138_W = 1.04f;
            if (driver.field_191988_bg == 0.0f && !this.engineBreak) {
                if (this.getAcceleration() < 0.5f && this.getAcceleration() > -0.5f) {
                    this.setAcceleration(0.0f);
                } else {
                    if (this.getAcceleration() > 0.0f) {
                        this.setAcceleration(this.getAcceleration() - 0.1f);
                    }
                    if (this.getAcceleration() < 0.0f) {
                        this.setAcceleration(this.getAcceleration() + 0.1f);
                    }
                }
            }
            if (this.getAcceleration() != 0.0f && !this.engineBreak) {
                double a = ((EntityPlayer)this.func_184179_bs()).field_70702_br * this.setTurnSpeed() * this.getAcceleration() * (this.getAcceleration() < 0.0f ? 0.3f : 0.87f);
                this.tireDirection = ((EntityPlayer)this.func_184179_bs()).field_70702_br;
                this.field_70126_B = this.field_70177_z = (float)((double)this.field_70177_z - a);
                this.field_70125_A = driver.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else if (this.getAcceleration() < 0.5f && this.getAcceleration() > -0.5f) {
            this.setAcceleration(0.0f);
        } else {
            if (this.getAcceleration() > 0.0f) {
                this.setAcceleration(this.getAcceleration() - 0.1f);
            }
            if (this.getAcceleration() < 0.0f) {
                this.setAcceleration(this.getAcceleration() + 0.1f);
            }
        }
        if (this.getAcceleration() < 0.0f) {
            this.setAcceleration(this.getAcceleration() - this.field_70143_R * 0.5f);
        } else if (this.getAcceleration() > 0.0f) {
            this.setAcceleration(this.getAcceleration() + this.field_70143_R * 0.5f);
        }
        if (this.field_70163_u > this.field_70167_r) {
            if (this.getAcceleration() > 0.0f) {
                this.setAcceleration(this.getAcceleration() - 0.3f);
            } else if (this.getAcceleration() < 0.0f) {
                this.setAcceleration(this.getAcceleration() + 1.2f);
            }
        }
        if (this.getAcceleration() > 13.0f) {
            this.setAcceleration(13.0f);
        } else if (this.getAcceleration() < -13.0f) {
            this.setAcceleration(-13.0f);
        }
        forward = this.getAcceleration() * this.setSpeed();
        if (this.getAcceleration() < 0.0f) {
            forward *= 0.2f;
        }
        if (this.func_184179_bs() instanceof EntityPlayer && forward != 0.0f) {
            this.tireRotation += Math.abs(1.8f) * forward * 6.0f;
        }
        if (this.tireRotation >= 360.0f) {
            this.tireRotation = 0.0f;
        }
        float calcX = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * forward * 1.0f;
        float calcZ = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * forward * 1.0f;
        this.func_145775_I();
        super.func_70030_z();
        this.field_70159_w += (double)calcX;
        this.field_70179_y += (double)calcZ;
        this.handleGravity();
        this.field_70159_w *= (double)0.6f;
        this.field_70181_x *= (double)0.6f;
        this.field_70179_y *= (double)0.6f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70123_F && this.field_70163_u == this.field_70167_r && this.getAcceleration() != 0.0f) {
            if (this.getAcceleration() >= 8.8f) {
                this.engineBreak = true;
            }
            this.setAcceleration(0.0f);
        }
    }

    private void handleGravity() {
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
        blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.2;
                if (this.field_70143_R >= 1.1f) {
                    this.field_70181_x -= 0.45;
                }
            }
        } else {
            this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
        }
        blockpos$pooledmutableblockpos.func_185344_t();
    }

    protected boolean func_184219_q(Entity passenger) {
        List list = this.func_184188_bt();
        if (!list.isEmpty()) {
            for (Entity e : list) {
                if (!(e instanceof EntityPlayer)) continue;
                return false;
            }
        }
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        if (!list.isEmpty()) {
            for (Entity e : list) {
                if (!(e instanceof EntityPlayer)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)source.func_76346_g()).func_70093_af()) {
            this.func_70106_y();
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_76316_a(IInventory invBasic) {
    }

    protected int getInventorySize() {
        return 54;
    }

    public int getInventoryColumns() {
        return 5;
    }

    protected void initVehicleChest() {
        ContainerVehicleChest containervehiclechest = this.vehicleChest;
        this.vehicleChest = new ContainerVehicleChest("VehicleInventory", this.getInventorySize());
        this.vehicleChest.func_110133_a(this.func_70005_c_());
        if (containervehiclechest != null) {
            containervehiclechest.func_110132_b(this);
            int i = Math.min(containervehiclechest.func_70302_i_(), this.vehicleChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = containervehiclechest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.vehicleChest.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.vehicleChest.func_110134_a(this);
        this.updateVehicleSlots();
    }

    protected void updateVehicleSlots() {
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            this.vehicleChest.func_110133_a(this.func_70005_c_());
            playerEntity.openGui((Object)ZAWAMain.instance, ZAWAMain.GUI.VEHICLE.id, this.field_70170_p, (int)playerEntity.field_70165_t, (int)playerEntity.field_70163_u, (int)playerEntity.field_70161_v);
        }
    }
}

