/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusSwimming;

public class EntityNileHippo
extends AbstractZawaLand {
    private boolean mouthOpen;
    private boolean tempted = false;
    private boolean holdingMelon = false;
    private int melonTicks = 0;

    public EntityNileHippo(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.5f);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.NILE_HIPPO;
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.field_70171_ac;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70613_aW() && this.field_70171_ac) {
            if (this.func_70661_as().func_75500_f()) {
                this.field_70181_x -= 0.001;
            } else {
                this.field_70159_w *= 1.2;
                this.field_70179_y *= 1.2;
                double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
                double waterLevel = this.func_174813_aQ().field_72337_e;
                double d2 = (waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O - 0.0;
                this.field_70181_x += d1;
                if (this.func_70055_a(Material.field_151586_h)) {
                    this.field_70181_x = 0.03f;
                }
                if (d2 > 0.0) {
                    this.field_70181_x += d2 * 0.06153846016296973;
                    this.field_70181_x *= 0.75;
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.field_70171_ac) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.HIPPO, RenderConstants.HIPPO_SLEEPING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.HIPPO_BABY, RenderConstants.HIPPO_BABY_SLEEPING});
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151127_ba), "Eats melon blocks"));
        s.add(new StatusSwimming());
        return new DataItem(s);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.NILEHIPPO_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.NILEHIPPO_HURT;
    }

    public boolean getTemped() {
        return this.tempted;
    }

    public boolean getHoldingMelon() {
        return this.holdingMelon;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (this.tempted && stack != null && !this.isAsleep() && (stack.func_77973_b() == Items.field_151127_ba || player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150440_ba))) {
            this.holdingMelon = true;
            this.tempted = false;
            stack.func_190918_g(1);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        if (this.holdingMelon) {
            ++this.melonTicks;
        }
        if (this.melonTicks >= 70) {
            this.melonTicks = 0;
            this.holdingMelon = false;
            if (this.func_70909_n()) {
                ModuleManager.HUNGER.setHunger(this, ModuleManager.HUNGER.getHunger(this) + 1.0f);
            }
            if (this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 2.8f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.1f) - (double)this.field_70130_N, this.field_70163_u + (double)1.4f, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 2.8f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.1f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Item.func_150891_b((Item)Items.field_151127_ba)});
                }
            }
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 4.0) != null && !this.func_70631_g_()) {
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 4.0);
            this.tempted = player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151127_ba || player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150440_ba);
        } else {
            if (!this.holdingMelon) {
                double distance = 6.0;
                Entity entityFound = null;
                double d4 = -1.0;
                for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (!(currE instanceof EntityItem) || ((EntityItem)currE).func_92059_d().func_77973_b() != Items.field_151127_ba && ((EntityItem)currE).func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150440_ba)) continue;
                    double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
                    d4 = d5;
                    entityFound = currE;
                }
                if (entityFound != null && !entityFound.field_70128_L) {
                    this.holdingMelon = true;
                    entityFound.func_70106_y();
                }
            }
            this.tempted = false;
        }
        if (this.field_70171_ac) {
            this.func_70050_g(20);
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityNileHippo(this.field_70170_p);
    }

    public boolean isMouthOpen() {
        return this.mouthOpen;
    }

    public void setMouthOpen(boolean mouthOpen) {
        this.mouthOpen = mouthOpen;
    }
}

