/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.DietHandler;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.ZAWAUtils;

public class EntityGrizzlyBear
extends AbstractZawaLand {
    private int lyingCoolDown = 0;
    private boolean lying = false;
    private boolean carryingSalmon = false;
    private int salmonTicks = 0;
    private boolean sit = false;
    public int lyingTime;
    public float lyingTimer;

    public EntityGrizzlyBear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.1f, 1.3f);
        this.sit = this.func_70681_au().nextBoolean();
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.GRIZZLY_BEAR;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return DietHandler.OpportunistItems(stack);
    }

    @Override
    @Nullable
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.BEAR, RenderConstants.BEAR_SLEEPING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.BEAR_BABY, RenderConstants.BEAR_BABY_SLEEPING});
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70681_au().nextBoolean() ? ZAWASounds.BEAR_ROAR : ZAWASounds.BEAR_ROAR_2;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_184639_G();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_184639_G();
    }

    public int getLyingCoolDown() {
        return this.lyingCoolDown;
    }

    public int getSalmonTicks() {
        return this.salmonTicks;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    public boolean getLyingType() {
        return this.sit;
    }

    public boolean getLying() {
        return this.getStillTicks() >= 120 && !this.carryingSalmon && !this.func_70631_g_();
    }

    public boolean getSalmon() {
        return this.carryingSalmon;
    }

    @SideOnly(value=Side.CLIENT)
    public void playEatEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (int i = 0; i < 3; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), d0, d1, d2, new int[0]);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.getLying()) {
            ++this.lyingTime;
            this.lyingTimer += 0.08f;
        } else {
            this.lyingTime = 0;
            this.lyingTimer = 0.0f;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70071_h_() {
        if (this.getStillTicks() >= 200) {
            this.sit = this.func_70681_au().nextBoolean();
        }
        if (this.func_70681_au().nextInt(200) == 4) {
            this.setStillTicks(0);
            this.sit = this.func_70681_au().nextBoolean();
        }
        if (ZAWAUtils.isEntityMoving((Entity)this) || this.field_70170_p.func_72890_a((Entity)this, 3.0) != null && !this.func_70909_n()) {
            this.setStillTicks(0);
            this.sit = this.func_70681_au().nextBoolean();
        }
        super.func_70071_h_();
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityGrizzlyBear(this.field_70170_p);
    }
}

