/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusClimbing;

public class EntityGoldenLionTamarin
extends AbstractZawaLand
implements IMultiSpeciesEntity {
    private boolean besideClimbable;

    public EntityGoldenLionTamarin(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.TAMARIN;
    }

    @Override
    @Nullable
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.GOLDEN_LION_TAMARIN, RenderConstants.GOLDEN_LION_TAMARIN_SLEEPING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.GOLDEN_LION_TAMARIN_BABY, RenderConstants.GOLDEN_LION_TAMARIN_BABY_SLEEPING});
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ZAWASounds.TAMARIN;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.54));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.43));
        super.func_184651_r();
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusClimbing());
        return new DataItem(s);
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70123_F) {
            if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            }
        }
    }

    public boolean isValidBlock(Block b) {
        return b instanceof BlockLog || b instanceof BlockLeaves || b instanceof BlockPlanks;
    }

    public boolean isBesideClimbableBlock() {
        return this.besideClimbable;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.besideClimbable = climbing;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock() && ZAWAConfig.serverOptions.canClimb;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityGoldenLionTamarin(this.field_70170_p);
    }

    @Override
    public Map<Integer, String> speciesData() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "Golden");
        map.put(1, "Golden Headed");
        map.put(2, "Black Headed");
        map.put(3, "Black");
        return map;
    }
}

