/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;

public class EntityAsianElephant
extends AbstractZawaLand {
    private int blocksToGround;
    private int blocksToGroundBack;

    public EntityAsianElephant(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.2f, 2.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.setYPosOffset(0.76f);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.ASIAN_ELEPHANT;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.ASIAN_ELEPHANT, RenderConstants.ASIAN_ELEPHANT_SLEEPING});
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.ASIAN_ELEPHANT_BABY_POSE, RenderConstants.ASIAN_ELEPHANT_BABY_SLEEPING});
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151141_av), "Can be mounted with a saddle"));
        return new DataItem(s);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!this.func_70631_g_()) {
            entity.field_70181_x += 0.6;
        }
        return super.func_70652_k(entity);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.ASIANELEPHANT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.ASIANELEPHANT_HURT;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityAsianElephant(this.field_70170_p);
    }

    public static class Segment {
        public Vector3f head;
        public Vector3f tail;
        public float angle;
        public int length;
        public Segment child;
        public Segment parent;

        public Segment(float x, float y, float z, int length) {
            this.head = new Vector3f(x, y, z);
            this.length = length;
            this.calculateTail();
        }

        public Segment(Segment parent, int length) {
            this.parent = parent;
            this.head = (Vector3f)parent.tail.clone();
            this.length = length;
            this.calculateTail();
        }

        public void calculateTail() {
            float deltaX = (float)((double)this.length * Math.cos(this.angle));
            float deltaZ = (float)((double)this.length * Math.sin(this.angle));
            float deltaY = (float)((double)this.length * Math.tan(this.angle));
            this.tail = new Vector3f(deltaX, deltaY, deltaZ);
        }

        public void follow() {
            float tx = this.child.head.x;
            float ty = this.child.head.y;
            float tz = this.child.head.z;
            this.follow(tx, ty, tz);
        }

        public void follow(float x, float y, float z) {
            Vector3f target = new Vector3f(x, y, z);
            Vector3f d = new Vector3f((this.head.x - target.x) * -1.0f, (this.head.y - target.y) * -1.0f, (this.head.z - target.z) * -1.0f);
            this.angle = this.head.angle(target) * 180.0f;
            this.head = new Vector3f(target.x + d.x, target.y + d.y, target.z + d.z);
        }
    }
}

