/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityRattleSnake;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderRattleSnake
extends RenderLivingZAWA<EntityRattleSnake> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderRattleSnake(RenderManager m) {
        super(m, (ModelBase)RenderConstants.RATTLESNAKE, 0.3f);
        RenderConstants.RATTLESNAKE.setAnimator(SnakeAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityRattleSnake e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        } else {
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityRattleSnake entity) {
        return CONTAINER.get(AbstractZawaLand.getVariant(entity));
    }

    static {
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake.png");
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake_2.png");
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake_3.png");
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake_4.png");
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake_5.png");
        CONTAINER.addResource("textures/entity/rattlesnake/rattlesnake_6.png");
    }

    public static class SnakeAnimator
    extends ZAWAAnimator<EntityRattleSnake> {
        public SnakeAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityRattleSnake entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            if (entity instanceof EntityRattleSnake) {
                if (!BookwormUtils.isEntityMoving((Entity)entity) && entity.func_70638_az() == null && !entity.func_70090_H()) {
                    this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.RATTLESNAKE_SLEEPING);
                }
                entity.getAnimator().updateModel((BookwormModelBase)this.getModel());
            }
        }
    }
}

