/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityPlatypus;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderPlatypus
extends RenderLivingZAWA<EntityPlatypus>
implements IBabyModel<EntityPlatypus> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderPlatypus(RenderManager m) {
        super(m, (ModelBase)RenderConstants.PLATYPUS, 0.3f);
        RenderConstants.PLATYPUS.setAnimator(PlatypusAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityPlatypus entity) {
        if (entity.func_70005_c_().equals("Perry")) {
            return CONTAINER.get("blink", 5);
        }
        return entity.func_70631_g_() ? CONTAINER.get("blink", 4) : CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityPlatypus entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)0.0f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityPlatypus entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        if (s != null && !s.equals("Perry")) {
            return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
        }
        return CONTAINER.get("special", 0);
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.PLATYPUS_BABY.setAnimator(PlatypusAnimator::new);
        return RenderConstants.PLATYPUS_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityPlatypus e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/platypus/platypus_1.png");
        CONTAINER.addResource("textures/entity/platypus/platypus_2.png");
        CONTAINER.addResource("textures/entity/platypus/platypus_3.png");
        CONTAINER.addResource("textures/entity/platypus/platypus_4.png");
        CONTAINER.addResource("baby", "textures/entity/platypus/baby.png");
        CONTAINER.addResource("special", "textures/entity/platypus/perry.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_baby.png");
        CONTAINER.addResource("blink", "textures/entity/platypus/platy_blink_perry.png");
    }

    public static class PlatypusAnimator
    extends ZAWAAnimator<EntityPlatypus> {
        private final BookwormModelRenderer LegLeft_1 = this.getModel().getPartByName("LegRight");
        private final BookwormModelRenderer Head = this.getModel().getPartByName("Head");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("ArmLeft");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("ArmRight");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("LegLeft");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");

        public PlatypusAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityPlatypus entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            float speed = 2.2f;
            float degree = 1.8f;
            this.Head.field_78795_f = f4 / 57.295776f - 0.2f;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * speed) + (float)Math.PI)) * (degree * -0.9f) * f1 * 0.5f - 0.2f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * speed) + (float)Math.PI)) * (degree * 0.9f) * f1 * 0.5f - 0.2f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * speed) + (float)Math.PI)) * (degree * 0.9f) * f1 * 0.5f - 0.2f;
            this.LegLeft_1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * speed) + (float)Math.PI)) * (degree * -0.9f) * f1 * 0.5f - 0.2f;
            this.Tail.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1662f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
        }
    }
}

