/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityJaguar;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderJaguar
extends RenderLivingZAWA<EntityJaguar>
implements IBabyModel<EntityJaguar> {
    public static final ResourceLocation BABY1 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_1.png");
    public static final ResourceLocation BABY2 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_2.png");
    public static final ResourceLocation BABY3 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_3.png");
    public static final ResourceLocation BABY4 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_4.png");
    public static final ResourceLocation BABY5 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_5.png");
    public static final ResourceLocation BABY6 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_baby_6.png");
    public static final ResourceLocation BLINK1 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_1.png");
    public static final ResourceLocation BLINK2 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_2.png");
    public static final ResourceLocation BLINK3 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_3.png");
    public static final ResourceLocation BLINK4 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_4.png");
    public static final ResourceLocation BLINK56 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_56.png");
    public static final ResourceLocation BBLINK1 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_baby_1.png");
    public static final ResourceLocation BBLINK2 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_baby_2.png");
    public static final ResourceLocation BBLINK3 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_baby_3.png");
    public static final ResourceLocation BBLINK4 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_baby_4.png");
    public static final ResourceLocation BBLINK56 = new ResourceLocation("zawa:textures/entity/jaguar/jaguar_blink_baby_56.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderJaguar(RenderManager m) {
        super(m, (ModelBase)RenderConstants.JAGUAR, 0.7f);
        RenderConstants.JAGUAR.setRig(new CMFRig(RenderConstants.JAGUAR, new ResourceLocation("zawa", "models/entity/bengal_tiger/tiger.rig")));
        RenderConstants.JAGUAR.setAnimator(RenderBengalTiger.TigerAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityJaguar entity) {
        if (entity.func_70631_g_()) {
            switch (AbstractZawaLand.getVariant(entity)) {
                default: {
                    return BBLINK1;
                }
                case 1: {
                    return BBLINK2;
                }
                case 2: {
                    return BBLINK3;
                }
                case 3: {
                    return BBLINK4;
                }
                case 4: 
                case 5: 
            }
            return BBLINK56;
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                return BLINK1;
            }
            case 1: {
                return BLINK2;
            }
            case 2: {
                return BLINK3;
            }
            case 3: {
                return BLINK4;
            }
            case 4: 
            case 5: 
        }
        return BLINK56;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityJaguar entitylivingbaseIn, float partialTickTime) {
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.2f);
        GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.2f);
        }
        if (entitylivingbaseIn.isAsleep()) {
            // empty if block
        }
    }

    protected ResourceLocation getEntityTexture(EntityJaguar entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.JAGUAR_BABY.setAnimator(RenderBengalTiger.BabyTigerAnimator::new);
        return RenderConstants.JAGUAR_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityJaguar e) {
        switch (AbstractZawaLand.getVariant(e)) {
            default: {
                return BABY1;
            }
            case 1: {
                return BABY2;
            }
            case 2: {
                return BABY3;
            }
            case 3: {
                return BABY4;
            }
            case 4: {
                return BABY5;
            }
            case 5: 
        }
        return BABY6;
    }

    static {
        CONTAINER.addResource("textures/entity/jaguar/jaguar_1.png");
        CONTAINER.addResource("textures/entity/jaguar/jaguar_2.png");
        CONTAINER.addResource("textures/entity/jaguar/jaguar_3.png");
        CONTAINER.addResource("textures/entity/jaguar/jaguar_4.png");
        CONTAINER.addResource("textures/entity/jaguar/jaguar_5.png");
        CONTAINER.addResource("textures/entity/jaguar/jaguar_6.png");
    }
}

