/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityGoldenLionTamarin;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGoldenLionTamarin
extends RenderLivingZAWA<EntityGoldenLionTamarin>
implements IBabyModel<EntityGoldenLionTamarin> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGoldenLionTamarin(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.GOLDEN_LION_TAMARIN, 0.4f);
        RenderConstants.GOLDEN_LION_TAMARIN.setAnimator(TamarinAnimator::new);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGoldenLionTamarin entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blinkb", AbstractZawaLand.getVariant(entity));
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    protected ResourceLocation getEntityTexture(EntityGoldenLionTamarin animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    protected void preRenderCallback(EntityGoldenLionTamarin entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.07f, (float)-0.1f);
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GOLDEN_LION_TAMARIN_BABY.setAnimator(TamarinChildAnimator::new);
        return RenderConstants.GOLDEN_LION_TAMARIN_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGoldenLionTamarin e) {
        return CONTAINER.get("baby", AbstractZawaLand.getVariant(e));
    }

    static {
        CONTAINER.addResource("textures/entity/goldenliontamarin/lion_tamarin.png");
        CONTAINER.addResource("textures/entity/goldenliontamarin/lion_tamarin_2.png");
        CONTAINER.addResource("textures/entity/goldenliontamarin/lion_tamarin_3.png");
        CONTAINER.addResource("textures/entity/goldenliontamarin/lion_tamarin_4.png");
        CONTAINER.addResource("baby", "textures/entity/goldenliontamarin/lion_tamarin_baby.png");
        CONTAINER.addResource("baby", "textures/entity/goldenliontamarin/lion_tamarin_baby_2.png");
        CONTAINER.addResource("baby", "textures/entity/goldenliontamarin/lion_tamarin_baby_3.png");
        CONTAINER.addResource("baby", "textures/entity/goldenliontamarin/lion_tamarin_baby_4.png");
        CONTAINER.addResource("blink", "textures/entity/goldenliontamarin/tamarin_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/goldenliontamarin/tamarin_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/goldenliontamarin/tamarin_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/goldenliontamarin/tamarin_blink_4.png");
        CONTAINER.addResource("blinkb", "textures/entity/goldenliontamarin/tamarin_blink_baby_1.png");
        CONTAINER.addResource("blinkb", "textures/entity/goldenliontamarin/tamarin_blink_baby_2.png");
        CONTAINER.addResource("blinkb", "textures/entity/goldenliontamarin/tamarin_blink_baby_3.png");
        CONTAINER.addResource("blinkb", "textures/entity/goldenliontamarin/tamarin_blink_baby_4.png");
    }

    private static class TamarinChildAnimator
    extends ZAWAAnimator<EntityGoldenLionTamarin> {
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartByName("Arm Left Base");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("Arm Left");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartByName("Hand Left");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartByName("Arm Base Right");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("Arm Right");
        private final BookwormModelRenderer HandRight = this.getModel().getPartByName("Hand Right");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("Thigh Right");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("Leg Right");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("Foot Right");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("Thigh Left");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("Leg Left");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("Foot Left");
        private final BookwormModelRenderer Body = this.getModel().getPartByName("body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");

        public TamarinChildAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGoldenLionTamarin entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 0.4f;
            this.speed = 7.4f;
            this.Neck.field_78795_f = f4 / 57.295776f - 0.2f;
            this.Neck.field_78808_h = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.04f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 1.3f;
            this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f - 1.3f;
            float weight = -1.9f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 3.8f) * f1 * 0.5f + weight;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 3.8f) * f1 * 0.5f + weight;
        }
    }

    private static class TamarinAnimator
    extends ZAWAAnimator<EntityGoldenLionTamarin> {
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartByName("Arm Left Base");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("Arm Left");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartByName("Hand Left");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartByName("Arm Base Right");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("Arm Right");
        private final BookwormModelRenderer HandRight = this.getModel().getPartByName("Hand Right");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("Thigh Right");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("Leg Right");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("Foot Right");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("Thigh Left");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("Leg Left");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("Foot Left");
        private final BookwormModelRenderer Body = this.getModel().getPartByName("body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private BookwormModelRenderer[] tailParts = new BookwormModelRenderer[11];
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");
        private final BookwormModelRenderer Tail1 = this.getModel().getPartByName("Tail1");
        private final BookwormModelRenderer Tail2 = this.getModel().getPartByName("Tail2");
        private final BookwormModelRenderer Tail3 = this.getModel().getPartByName("Tail3");
        private final BookwormModelRenderer Tail4 = this.getModel().getPartByName("Tail4");
        private final BookwormModelRenderer Tail5 = this.getModel().getPartByName("Tail5");
        private final BookwormModelRenderer Tail6 = this.getModel().getPartByName("Tail6");
        private final BookwormModelRenderer Tail7 = this.getModel().getPartByName("Tail7");
        private final BookwormModelRenderer Tail8 = this.getModel().getPartByName("Tail8");
        private final BookwormModelRenderer Tail9 = this.getModel().getPartByName("Tail9");
        private final BookwormModelRenderer Tail10 = this.getModel().getPartByName("Tail10");

        public TamarinAnimator(ModelCMF model) {
            super(model);
            this.tailParts[0] = this.Tail;
            this.tailParts[1] = this.Tail1;
            this.tailParts[2] = this.Tail2;
            this.tailParts[3] = this.Tail3;
            this.tailParts[4] = this.Tail4;
            this.tailParts[5] = this.Tail5;
            this.tailParts[6] = this.Tail6;
            this.tailParts[7] = this.Tail7;
            this.tailParts[8] = this.Tail8;
            this.tailParts[9] = this.Tail9;
            this.tailParts[10] = this.Tail10;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGoldenLionTamarin entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 0.4f;
            this.speed = 8.4f;
            this.Neck.field_78795_f = f4 / 57.295776f - 0.2f;
            this.Neck.field_78808_h = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            for (int i = 0; i < this.tailParts.length; ++i) {
                if (i == 0 || i == 3 || i == 6) continue;
                this.tailParts[i].field_78795_f += MathHelper.func_76126_a((float)(23.0f + f * 0.1f * (float)i)) * f1 * 0.1f;
            }
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82907_q = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 1.3f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.2f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82907_q = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f - 1.3f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f - 0.2f;
            this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            float weight = -1.9f;
            float weight2 = 0.4f;
            float x = 0.1f;
            this.ThighRight.field_82907_q = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + x;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 3.8f) * f1 * 0.5f + weight;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 1.6f) * f1 * 0.5f + weight2;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82907_q = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + x;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 3.8f) * f1 * 0.5f + weight;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 1.6f) * f1 * 0.5f + weight2;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f - 0.0f;
        }
    }
}

