/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.general.EntityEggShell;
import org.zawamod.util.EggData;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderEggShell
extends RenderLiving<EntityEggShell> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("zawa", "textures/entity/egg/egg.png");

    public RenderEggShell(RenderManager r) {
        super(r, (ModelBase)RenderConstants.EGG_BOTTOM, 0.1f);
        this.func_177094_a(new LayerEgg(this));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityEggShell e) {
        if (e.isTop()) {
            return null;
        }
        if (ZAWAMain.proxy.getEggData().containsKey(e.getType()) && ZAWAMain.proxy.getEggData().get(e.getType()).getResource() != null) {
            return ZAWAMain.proxy.getEggData().get(e.getType()).getResource();
        }
        return TEXTURE;
    }

    public void doRender(EntityEggShell entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179133_A();
        GlStateManager.func_179121_F();
    }

    protected void preRenderCallback(EntityEggShell e, float partialTickTime) {
        super.func_77041_b((EntityLivingBase)e, partialTickTime);
        if (ZAWAMain.proxy.getEggData().containsKey(e.getType())) {
            EggData data = ZAWAMain.proxy.getEggData().get(e.getType());
            GlStateManager.func_179152_a((float)data.getScaleX(), (float)data.getScaleY(), (float)data.getScaleZ());
        }
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private static class LayerEgg
    implements LayerRenderer<EntityEggShell> {
        private RenderEggShell render;

        public LayerEgg(RenderEggShell render) {
            this.render = render;
        }

        public ResourceLocation getTex(EntityEggShell e) {
            if (ZAWAMain.proxy.getEggData().containsKey(e.getType()) && ZAWAMain.proxy.getEggData().get(e.getType()).getResource() != null) {
                return ZAWAMain.proxy.getEggData().get(e.getType()).getResource();
            }
            return TEXTURE;
        }

        public void doRenderLayer(EntityEggShell e, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (e.func_82150_aj() || !e.isTop()) {
                return;
            }
            this.render.func_110776_a(this.getTex(e));
            RenderConstants.EGG.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

