/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBottlenoseDolphin;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.water.EntityBotoRiverDolphin;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderBotoRiverDolphin
extends RenderLivingZAWA<EntityBotoRiverDolphin>
implements IBabyModel<EntityBotoRiverDolphin> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderBotoRiverDolphin(RenderManager m) {
        super(m, (ModelBase)RenderConstants.PINK_DOLPHIN.setAnimator(DolphinAnimator::new), 0.6f);
        this.func_177094_a(new RenderBottlenoseDolphin.LayerBottlenoseDolphin());
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityBotoRiverDolphin e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        }
        if (e.getBobTicks() >= 5 || e.getHeldFood() != ItemStack.field_190927_a) {
            GlStateManager.func_179114_b((float)-35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)-0.9f);
        } else {
            GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityBotoRiverDolphin entity) {
        return this.getTextureOfVar(entity);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityBotoRiverDolphin e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.PINK_DOLPHIN_BABY.setAnimator(DolphinAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBotoRiverDolphin e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/boto_river_dolphin/1.png");
        CONTAINER.addResource("textures/entity/boto_river_dolphin/2.png");
        CONTAINER.addResource("textures/entity/boto_river_dolphin/3.png");
        CONTAINER.addResource("textures/entity/boto_river_dolphin/4.png");
        CONTAINER.addResource("baby", "textures/entity/boto_river_dolphin/pink_river_dolphin_baby.png");
    }

    public static class DolphinAnimator
    extends ZAWAAnimator<EntityBotoRiverDolphin> {
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer Head = this.getModel().getPartFromRig("Head");
        protected final BookwormModelRenderer Hips = this.getModel().getPartFromRig("Hips");
        protected final BookwormModelRenderer TailBase = this.getModel().getPartFromRig("TailBase");
        protected final BookwormModelRenderer Tail = this.getModel().getPartFromRig("Tail");
        protected final BookwormModelRenderer TailEnd = this.getModel().getPartFromRig("TailEnd");
        protected final BookwormModelRenderer Jaw = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer FinRight = this.getModel().getPartFromRig("FinRight");
        protected final BookwormModelRenderer FinLeft = this.getModel().getPartFromRig("FinLeft");

        public DolphinAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float limbSwing, float limbSwingAmount, float f2, float f3, float f4, float f5, EntityBotoRiverDolphin entity) {
            super.performGenericAnimation(limbSwing, limbSwingAmount, f2, f3, f4, f5, entity);
            limbSwing = entity.field_70173_aa;
            limbSwingAmount = ZAWAUtils.isEntityMoving((Entity)entity) ? 0.04f : 0.1f;
            if (entity.func_70090_H() || entity.field_70163_u != entity.field_70167_r) {
                if (entity.getHeldFood() == ItemStack.field_190927_a) {
                    this.Head.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.1662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.1f;
                    this.Body.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.1662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.1f;
                }
                this.Hips.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.2662f + (float)Math.PI)) * 2.4f * limbSwingAmount * 0.5f;
                this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f;
                this.Tail.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f;
                this.TailEnd.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f;
                if (entity.getHeldFood() == ItemStack.field_190927_a) {
                    this.Head.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.1662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.1f;
                    this.Body.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.1662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.1f;
                }
            } else {
                if (entity.getHeldFood() == ItemStack.field_190927_a) {
                    this.Jaw.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.2f + 0.1f;
                }
                this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.2f;
                this.TailEnd.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.2f;
            }
            if ((entity.func_70090_H() || entity.field_70122_E || entity.getHeldFood() != ItemStack.field_190927_a) && (entity.getBobTicks() >= 10 || entity.getHeldFood() != ItemStack.field_190927_a)) {
                this.Jaw.field_78795_f += 0.4f;
            }
            if (entity.func_70090_H() || entity.field_70163_u != entity.field_70167_r) {
                this.FinRight.field_78808_h = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f - 0.3f;
                this.FinLeft.field_78808_h = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.5f - -0.3f;
                this.FinRight.field_78796_g = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.5f - -0.3f;
                this.FinLeft.field_78796_g = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.2662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f - 0.3f;
            } else {
                this.FinRight.field_78808_h = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f - 0.2f;
                this.FinLeft.field_78808_h = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.5f - -0.2f;
                this.FinRight.field_78796_g = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * -0.5f - -0.2f;
                this.FinLeft.field_78796_g = MathHelper.func_76134_b((float)(10.0f + limbSwing * 0.0662f + (float)Math.PI)) * 3.4f * limbSwingAmount * 0.5f - 0.2f;
            }
        }
    }
}

