/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.flying.EntityAlbatross;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAlbatross
extends RenderLivingZAWA<EntityAlbatross>
implements IBabyModel<EntityAlbatross> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAlbatross(RenderManager m) {
        super(m, (ModelBase)RenderConstants.ALBATROSS, 0.7f);
        RenderConstants.ALBATROSS.setAnimator(AlbatrossAnimator::new);
    }

    @Override
    public void preRender(EntityAlbatross e, RenderLivingZAWA render) {
        GlStateManager.func_179114_b((float)e.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    protected ResourceLocation getEntityTexture(EntityAlbatross animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAlbatross e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAlbatross entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("babyBlink", 0);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.ALBATROSS_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAlbatross e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/albatross/albatross_1.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_2.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_3.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_4.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_5.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_6.png");
        CONTAINER.addResource("textures/entity/albatross/albatross_7.png");
        CONTAINER.addResource("baby", "textures/entity/albatross/albatross_baby.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_5.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_6.png");
        CONTAINER.addResource("blink", "textures/entity/albatross/albatross_blink_7.png");
        CONTAINER.addResource("babyBlink", "textures/entity/albatross/albatross_baby_blinks.png");
    }

    public static class AlbatrossAnimator
    extends ZAWAAnimator<EntityAlbatross> {
        protected final BookwormModelRenderer Jaw = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer Neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        protected final BookwormModelRenderer Wing1Left = this.getModel().getPartFromRig("Wing1Left");
        protected final BookwormModelRenderer Wing2Left = this.getModel().getPartFromRig("Wing2Left");
        protected final BookwormModelRenderer Wing1Right = this.getModel().getPartFromRig("Wing1Right");
        protected final BookwormModelRenderer Wing2Right = this.getModel().getPartFromRig("Wing2Right");
        protected final BookwormModelRenderer Tail1 = this.getModel().getPartFromRig("Tail1");
        protected final BookwormModelRenderer Tail2 = this.getModel().getPartFromRig("Tail2");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        protected final BookwormModelRenderer Head = this.getModel().getPartFromRig("Head");
        protected final BookwormModelRenderer WingFoldedRight = this.getModel().getPartFromRig("WingFoldedRight");
        protected final BookwormModelRenderer WingFoldedLeft = this.getModel().getPartFromRig("WingFoldedLeft");
        protected final BookwormModelRenderer Chest = this.getModel().getPartByName("Chest");
        protected final BookwormModelRenderer TailBase = this.getModel().getPartByName("TailBase");
        protected final BookwormModelRenderer Neck1 = this.getModel().getPartByName("Neck1");
        protected final BookwormModelRenderer Neck2 = this.getModel().getPartByName("Neck2");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");

        public AlbatrossAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAlbatross entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.4f;
            this.degree = 1.9f;
            if (!entity.field_70122_E && !entity.func_184218_aH()) {
                this.Wing1Left.renderPartScale = 1.0f;
                this.Wing1Right.renderPartScale = 1.0f;
                this.WingFoldedRight.renderPartScale = 0.0f;
                this.WingFoldedLeft.renderPartScale = 0.0f;
                this.degree = 1.0f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.ALBATROSS_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.Wing1Left.field_78808_h = MathHelper.func_76134_b((float)(f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f;
                this.Wing2Left.field_78808_h = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * -0.3f) * f1 * 0.5f;
                this.Wing1Right.field_78808_h = MathHelper.func_76134_b((float)(f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f;
                this.Wing2Right.field_78808_h = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.05f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.07f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 1.4f;
                this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.06f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.1f;
            } else {
                this.Wing1Left.renderPartScale = 0.0f;
                this.Wing1Right.renderPartScale = 0.0f;
                this.WingFoldedRight.renderPartScale = 1.0f;
                this.WingFoldedLeft.renderPartScale = 1.0f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + 0.2f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(2.5f + f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f + -0.25f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * -1.0f) * f1 * 0.5f + 0.15f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + 0.2f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(2.5f + f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * -2.1f) * f1 * 0.5f + -0.25f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.25f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f + 0.15f;
                this.Chest.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * 0.15f) * f1 * 0.5f + 0.87f;
                this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * -0.15f) * f1 * 0.5f + -0.34f;
                this.Neck2.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * -0.05f) * f1 * 0.5f + -0.24f;
                this.Head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.15f;
            }
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAlbatross entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 0.8f;
            this.Chest.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.15f) * f1 * 0.5f + 0.87f;
            this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * -0.15f) * f1 * 0.5f + -0.34f;
            this.Neck2.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * -0.05f) * f1 * 0.5f + -0.24f;
            this.Head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.15f;
        }
    }
}

