/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.client.ambience;

import java.util.ConcurrentModificationException;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2465;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_638;
import net.minecraft.class_746;
import svenhjol.charm.Charm;
import svenhjol.charm.base.helper.DimensionHelper;
import svenhjol.charmonium.client.LongSound;
import svenhjol.charmonium.client.ShortSound;
import svenhjol.charmonium.iface.IAmbientSounds;
import svenhjol.charmonium.module.Sounds;

public abstract class BaseAmbientSounds
implements IAmbientSounds {
    protected int shortTicks = 0;
    protected boolean isValid = false;
    protected class_1101 longSound = null;
    protected final class_1657 player;
    protected final class_638 world;
    protected final class_1144 soundHandler;

    public BaseAmbientSounds(class_1657 player, class_1144 soundHandler) {
        this.player = player;
        this.soundHandler = soundHandler;
        this.world = (class_638)player.field_6002;
    }

    public void tick() {
        boolean nowValid = this.isValid();
        if (this.isValid && !nowValid) {
            this.isValid = false;
        }
        if (!this.isValid && nowValid) {
            this.isValid = true;
            this.shortTicks = this.getShortSoundDelay();
        }
        if (nowValid && this.hasShortSound() && --this.shortTicks <= 0) {
            this.setShortSound();
            this.shortTicks = this.getShortSoundDelay();
        }
        if (this.isValid && this.hasLongSound() && !this.isPlayingLongSound()) {
            this.setLongSound();
            try {
                this.soundHandler.method_4873((class_1113)this.longSound);
            }
            catch (ConcurrentModificationException e) {
                Charm.LOG.debug("Exception in tick");
            }
        }
    }

    public boolean isOutside() {
        if (!DimensionHelper.isOverworld((class_1937)this.player.field_6002) && !Sounds.outdoorDimensions.contains(DimensionHelper.getDimension((class_1937)this.player.field_6002))) {
            return false;
        }
        if (this.player.method_5869()) {
            return false;
        }
        int blocks = 16;
        int start = 1;
        class_2338 playerPos = this.player.method_24515();
        for (int i = start; i < start + blocks; ++i) {
            class_2338 check = new class_2338(playerPos.method_10263(), playerPos.method_10264() + i, playerPos.method_10260());
            class_2680 state = this.world.method_8320(check);
            class_2248 block = state.method_26204();
            if (this.world.method_22348(check)) {
                return true;
            }
            if (this.world.method_22347(check) || state.method_26207() == class_3614.field_15942 || block instanceof class_2465 && state.method_26207() == class_3614.field_15932 || block instanceof class_2381 || block instanceof class_2513 || !state.method_26225()) continue;
            return false;
        }
        return this.player.method_24515().method_10264() >= 48;
    }

    protected void setShortSound() {
        ShortSound shortSound = new ShortSound((class_746)this.player, this.getShortSound(), this.getShortSoundVolume() * (float)Sounds.volumeMultiplier);
        try {
            if (!this.soundHandler.method_4877((class_1113)shortSound)) {
                this.soundHandler.method_4873((class_1113)shortSound);
            }
        }
        catch (ConcurrentModificationException e) {
            Charm.LOG.debug("Exception in setShortSound");
        }
    }

    protected void setLongSound() {
        this.longSound = new LongSound(this.player, this.getLongSound(), this.getLongSoundVolume() * (float)Sounds.volumeMultiplier, p -> this.isValid());
    }

    public boolean isPlayingLongSound() {
        return this.longSound != null && !this.longSound.method_4793();
    }

    public float getShortSoundVolume() {
        return 0.4f;
    }

    public float getLongSoundVolume() {
        return 0.3f;
    }

    public int getShortSoundDelay() {
        return this.world.field_9229.nextInt(400) + 400;
    }

    public boolean hasLongSound() {
        return this.getLongSound() != null;
    }

    public boolean hasShortSound() {
        return this.getShortSound() != null;
    }

    @Override
    public class_638 getWorld() {
        return this.world;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public class_1144 getSoundManager() {
        return this.soundHandler;
    }
}

