/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.client.ambience;

import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.client.PlayerStateClient;
import svenhjol.charm.module.SnowStorms;
import svenhjol.charmonium.base.CharmoniumSounds;
import svenhjol.charmonium.client.ambience.BaseAmbientSounds;
import svenhjol.charmonium.iface.IBiomeAmbience;

public class IcyAmbientSounds {

    public static class Thunderstorm
    extends BaseAmbientSounds
    implements IBiomeAmbience {
        public Thunderstorm(PlayerEntity player, SoundHandler soundHandler) {
            super(player, soundHandler);
        }

        @Override
        @Nullable
        public SoundEvent getLongSound() {
            return CharmoniumSounds.AMBIENCE_ICY_THUNDERSTORM;
        }

        @Override
        public float getLongSoundVolume() {
            return super.getLongSoundVolume() + 0.25f;
        }

        @Override
        public boolean validBiomeConditions(Biome.Category biomeCategory) {
            return biomeCategory == Biome.Category.ICY && this.isOutside() && this.getWorld().func_72911_I() && ModuleHandler.enabled(SnowStorms.class);
        }
    }

    public static class Night
    extends BaseAmbientSounds
    implements IBiomeAmbience {
        public Night(PlayerEntity player, SoundHandler soundHandler) {
            super(player, soundHandler);
        }

        @Override
        @Nullable
        public SoundEvent getLongSound() {
            return CharmoniumSounds.AMBIENCE_ICY_NIGHT_LONG;
        }

        @Override
        public boolean validBiomeConditions(Biome.Category biomeCategory) {
            return biomeCategory == Biome.Category.ICY && this.isOutside() && !PlayerStateClient.INSTANCE.isDaytime;
        }
    }

    public static class Day
    extends BaseAmbientSounds
    implements IBiomeAmbience {
        public Day(PlayerEntity player, SoundHandler soundHandler) {
            super(player, soundHandler);
        }

        @Override
        @Nullable
        public SoundEvent getLongSound() {
            return CharmoniumSounds.AMBIENCE_ICY_DAY_LONG;
        }

        @Override
        @Nullable
        public SoundEvent getShortSound() {
            return CharmoniumSounds.AMBIENCE_ICY_DAY_SHORT;
        }

        @Override
        public int getShortSoundDelay() {
            return this.world.field_73012_v.nextInt(400) + 500;
        }

        @Override
        public boolean validBiomeConditions(Biome.Category biomeCategory) {
            return biomeCategory == Biome.Category.ICY && PlayerStateClient.INSTANCE.isDaytime && this.isOutside();
        }
    }
}

