/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.client.ambience;

import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import svenhjol.charm.base.helper.DimensionHelper;
import svenhjol.charmonium.base.CharmoniumSounds;
import svenhjol.charmonium.client.ambience.BaseAmbientSounds;

public class DeepAmbientSounds
extends BaseAmbientSounds {
    public DeepAmbientSounds(PlayerEntity player, SoundHandler soundHandler) {
        super(player, soundHandler);
    }

    @Override
    public boolean isValid() {
        if (this.world == null || !DimensionHelper.isDimension((World)this.world, (ResourceLocation)new ResourceLocation("overworld"))) {
            return false;
        }
        BlockPos pos = this.player.func_233580_cy_();
        int light = this.world.func_201696_r(pos);
        return !this.world.func_175710_j(pos) && pos.func_177956_o() <= 32 && light < 10;
    }

    @Override
    public int getShortSoundDelay() {
        return this.world.field_73012_v.nextInt(400) + 1000;
    }

    @Override
    public float getLongSoundVolume() {
        return 0.65f;
    }

    @Override
    @Nullable
    public SoundEvent getLongSound() {
        return CharmoniumSounds.AMBIENCE_DEEP_LONG;
    }

    @Override
    @Nullable
    public SoundEvent getShortSound() {
        return CharmoniumSounds.AMBIENCE_DEEP_SHORT;
    }
}

