/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.client.ambience;

import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import svenhjol.charm.base.helper.DimensionHelper;
import svenhjol.charmonium.base.CharmoniumSounds;
import svenhjol.charmonium.client.ambience.BaseAmbientSounds;

public class CaveAmbientSounds
extends BaseAmbientSounds {
    public CaveAmbientSounds(PlayerEntity player, SoundHandler soundHandler) {
        super(player, soundHandler);
    }

    public static boolean isValidCave(ClientWorld world, PlayerEntity player) {
        if (world == null || !DimensionHelper.isDimension((World)world, (ResourceLocation)new ResourceLocation("overworld"))) {
            return false;
        }
        if (player.func_204231_K()) {
            return false;
        }
        BlockPos pos = player.func_233580_cy_();
        int light = world.func_201696_r(pos);
        if (!world.func_175710_j(pos) && pos.func_177956_o() <= world.func_181545_F()) {
            return pos.func_177956_o() <= 44 || light <= 10;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return CaveAmbientSounds.isValidCave(this.world, this.player);
    }

    @Override
    public int getShortSoundDelay() {
        return this.world.field_73012_v.nextInt(500) + 600;
    }

    @Override
    public float getLongSoundVolume() {
        return 0.35f;
    }

    @Override
    @Nullable
    public SoundEvent getLongSound() {
        return CharmoniumSounds.AMBIENCE_CAVE_LONG;
    }

    @Override
    @Nullable
    public SoundEvent getShortSound() {
        return CharmoniumSounds.AMBIENCE_CAVE_SHORT;
    }
}

