/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.structure;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.GelTemplate;
import com.legacy.structure_gel.worldgen.IModifyState;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Logger;

public abstract class GelTemplateStructurePiece
extends TemplateStructurePiece
implements IModifyState {
    private static final Logger LOGGER = StructureGelMod.makeLogger("GelTemplateStructurePiece");
    public final ResourceLocation name;
    public Rotation field_186169_c = Rotation.NONE;
    public Mirror field_186168_b = Mirror.NONE;

    public GelTemplateStructurePiece(IStructurePieceType structurePieceTypeIn, ResourceLocation name, int componentTypeIn) {
        super(structurePieceTypeIn, componentTypeIn);
        this.name = name;
    }

    public GelTemplateStructurePiece(IStructurePieceType structurePieceType, CompoundNBT nbt) {
        super(structurePieceType, nbt);
        this.name = new ResourceLocation(nbt.func_74779_i("Template"));
        this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.field_186168_b = Mirror.valueOf((String)nbt.func_74779_i("Mirror"));
    }

    public void setupTemplate(TemplateManager templateManager) {
        this.func_186173_a(templateManager.func_200220_a(this.name), this.field_186178_c, this.getPlacementSettings(templateManager));
    }

    public PlacementSettings getPlacementSettings(TemplateManager templateManager) {
        PlacementSettings placementSettings = this.createPlacementSettings(templateManager);
        this.addProcessors(templateManager, placementSettings);
        return placementSettings;
    }

    public PlacementSettings createPlacementSettings(TemplateManager templateManager) {
        return new GelPlacementSettings().setMaintainWater(true).func_186220_a(this.field_186169_c).func_186214_a(this.field_186168_b);
    }

    public void addProcessors(TemplateManager templateManager, PlacementSettings placementSettings) {
        placementSettings.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        placementSettings.func_215222_a((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.name.toString());
        nbt.func_74778_a("Rot", this.field_186169_c.name());
        nbt.func_74778_a("Mirror", this.field_186168_b.name());
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        this.field_186177_b.func_186223_a(bounds);
        this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
        if (new GelTemplate(this.field_186176_a).func_237146_a_((IServerWorld)world, this.field_186178_c, pos, this.field_186177_b, rand, 2, this::modifyState)) {
            for (Template.BlockInfo blockInfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_185779_df)) {
                if (blockInfo.field_186244_c == null || StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode")) != StructureMode.DATA) continue;
                this.func_186175_a(blockInfo.field_186244_c.func_74779_i("metadata"), blockInfo.field_186242_a, (IServerWorld)world, rand, bounds);
            }
            for (Template.BlockInfo blockInfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_226904_lY_)) {
                if (blockInfo.field_186244_c == null) continue;
                String stateString = blockInfo.field_186244_c.func_74779_i("final_state");
                BlockStateParser stateParser = new BlockStateParser(new StringReader(stateString), false);
                BlockState state = Blocks.field_150350_a.func_176223_P();
                try {
                    stateParser.func_197243_a(true);
                    BlockState parsedState = stateParser.func_197249_b();
                    if (parsedState != null) {
                        state = parsedState;
                    } else {
                        LOGGER.error("Error while parsing blockstate {} in structure block @ {}", (Object)stateString, (Object)blockInfo.field_186242_a);
                    }
                }
                catch (CommandSyntaxException ex) {
                    LOGGER.error("Error while parsing blockstate {} in structure block @ {}", (Object)stateString, (Object)blockInfo.field_186242_a);
                }
                world.func_180501_a(blockInfo.field_186242_a, state, 3);
            }
        }
        return true;
    }

    @Override
    @Nullable
    public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
        return originalState;
    }
}

