/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.blocks;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.blocks.IStructureGel;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StructureGelBlock
extends Block
implements IStructureGel {
    public static final IntegerProperty COUNT = IntegerProperty.func_177719_a((String)"count", (int)0, (int)51);
    public final List<IStructureGel.IBehavior> behaviors;

    public StructureGelBlock(IStructureGel.IBehavior ... behaviors) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_222380_e().func_226896_b_().func_200947_a(SoundType.field_185859_l).func_235827_a_((state, reader, pos, entity) -> false).func_235842_b_((state, reader, pos) -> false).func_235847_c_((state, reader, pos) -> false));
        this.behaviors = ImmutableList.copyOf((Object[])behaviors);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)COUNT, (Comparable)Integer.valueOf(50)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j().func_184812_l_()) {
            BlockState hookState = this.onHandPlaceHook(context);
            if (hookState != null) {
                return hookState;
            }
            int count = 50;
            if (context.func_195999_j().func_225608_bj_()) {
                count = 0;
                if (this.behaviors.contains(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST)) {
                    count = Math.min(Math.max(50 - context.func_195996_i().func_190916_E(), 0), 50);
                }
            }
            return (BlockState)this.func_176223_P().func_206870_a((Property)COUNT, (Comparable)Integer.valueOf(count));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)COUNT) < 50) {
            if (!this.spreadHookPre(state, (World)worldIn, pos, random)) {
                return;
            }
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.func_177972_a(d);
                this.addGel(state, (World)worldIn, offset, (Integer)state.func_177229_b((Property)COUNT) + 1);
                if (!this.behaviors.contains(IStructureGel.Behavior.DIAGONAL_SPREAD)) continue;
                if (d == Direction.UP || d == Direction.DOWN) {
                    for (int i = 0; i < 4; ++i) {
                        this.addGel(state, (World)worldIn, offset.func_177972_a(Direction.func_176731_b((int)i)), (Integer)state.func_177229_b((Property)COUNT) + 1);
                    }
                    continue;
                }
                this.addGel(state, (World)worldIn, offset.func_177972_a(d.func_176746_e()), (Integer)state.func_177229_b((Property)COUNT) + 1);
            }
            this.setGel(state, (World)worldIn, pos, 50);
            this.spreadHookPost(state, (World)worldIn, pos, random);
        } else if ((Integer)state.func_177229_b((Property)COUNT) == 51) {
            if (!this.removalHookPre(state, (World)worldIn, pos, random)) {
                return;
            }
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.func_177972_a(d);
                this.removeGel(state, (World)worldIn, offset);
                if (!this.behaviors.contains(IStructureGel.Behavior.DIAGONAL_SPREAD)) continue;
                if (d == Direction.UP || d == Direction.DOWN) {
                    for (int i = 0; i < 4; ++i) {
                        this.removeGel(state, (World)worldIn, offset.func_177972_a(Direction.func_176731_b((int)i)));
                    }
                    continue;
                }
                this.removeGel(state, (World)worldIn, offset.func_177972_a(d.func_176746_e()));
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            this.removalHookPost(state, (World)worldIn, pos, random);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184812_l_() && player.func_184586_b(handIn).func_77973_b() == Items.field_151016_H) {
            this.removeGel(state, worldIn, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_184812_l_()) {
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.func_177972_a(d);
                if (worldIn.func_180495_p(offset).func_177230_c() != this) continue;
                this.removeGel(state, worldIn, offset);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void addGel(BlockState state, World worldIn, BlockPos pos, int count) {
        if (worldIn.func_175623_d(pos) && this.checkAbove(worldIn, pos) && this.checkPlacementHook(worldIn, pos, count)) {
            this.setGel(state, worldIn, pos, count);
        }
    }

    public void removeGel(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.setGel(state, worldIn, pos, 51);
        }
    }

    public void setGel(BlockState state, World worldIn, BlockPos pos, int count) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COUNT, (Comparable)Integer.valueOf(count)), 2);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)worldIn.func_180495_p(pos).func_177230_c(), 2);
    }

    public boolean checkAbove(World worldIn, BlockPos pos) {
        if (!this.behaviors.contains(IStructureGel.Behavior.PHOTOSENSITIVE)) {
            return true;
        }
        if (!worldIn.func_226660_f_(pos)) {
            return true;
        }
        int dy = 1;
        while (pos.func_177981_b(dy).func_177956_o() < 256) {
            if (!worldIn.func_175623_d(pos.func_177981_b(dy))) {
                return true;
            }
            ++dy;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COUNT});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }
}

