/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.SGClientEvents;
import com.legacy.structure_gel.SGEvents;
import com.legacy.structure_gel.SGRegistry;
import com.legacy.structure_gel.StructureGelCompat;
import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.util.Internal;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structure_gel")
public class StructureGelMod {
    public static final String MODID = "structure_gel";
    public static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/structure_gel");

    public StructureGelMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, StructureGelConfig.COMMON_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        SGEvents.init(modBus, forgeBus);
        modBus.addGenericListener(BiomeType.class, SGRegistry::registerBiomeDictionary);
        modBus.addGenericListener(Block.class, SGRegistry.GelBlocks::onRegistry);
        modBus.addGenericListener(Item.class, SGRegistry.GelItems::onRegistry);
        modBus.addGenericListener(Structure.class, SGRegistry.StructureRegistry::onRegistry);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, StructureGelConfig.CLIENT_SPEC);
            SGClientEvents.init(modBus, forgeBus);
        });
        StructureGelCompat.init(modBus);
    }

    @Internal
    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    @Internal
    public static Logger makeLogger(String name) {
        return LogManager.getLogger((String)("ModdingLegacy/structure_gel/" + name));
    }
}

