/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.util.Internal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@Internal
public class StructureGelConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    protected static final ForgeConfigSpec COMMON_SPEC;
    protected static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Client {
        private final ForgeConfigSpec.BooleanValue skipExperimentalBackupScreen;
        private final ForgeConfigSpec.BooleanValue fixSpawners;
        private final ForgeConfigSpec.BooleanValue showStructureBlockInfo;

        public Client(ForgeConfigSpec.Builder builder) {
            this.skipExperimentalBackupScreen = builder.comment("Skips the screen that tells you that a world uses experimental settings.").define("gui.skip_experimental_backup_screen", true);
            this.fixSpawners = builder.comment("Fixes spawners causing fps lag from a ClassCastException with some entities.").define("entity.fix_spawners", true);
            this.showStructureBlockInfo = builder.comment("Displays info on top of Structure Blocks, similarly to pre-1.13 versions.").define("gui.show_structure_block_info", true);
        }

        public boolean skipExperimentalScreen() {
            return (Boolean)this.skipExperimentalBackupScreen.get();
        }

        public boolean fixSpawners() {
            return (Boolean)this.fixSpawners.get();
        }

        public boolean showStructureBlockInfo() {
            return (Boolean)this.showStructureBlockInfo.get();
        }
    }

    public static class Common {
        private final ForgeConfigSpec.BooleanValue extraLakeProofing;
        private final ForgeConfigSpec.ConfigValue<String> ignoredMods;
        private final ForgeConfigSpec.BooleanValue guessBiomeDict;
        private final ForgeConfigSpec.BooleanValue exceedFillLimit;

        public Common(ForgeConfigSpec.Builder builder) {
            this.extraLakeProofing = builder.comment("Adds more vanilla structures to the list of structures that lakes cannot generate inside of. Only villages when set to false. Requires reload.").define("features.extra_lake_proofing", true);
            this.ignoredMods = builder.comment("A list of mod IDs that will be ignored when the biome dictionary attempts to register unregistered biomes. Mod IDs must be comma separated (\"biomesoplenty, byg, blue_skies\").").define("biome_dictionary.ignored_mods", (Object)"");
            this.guessBiomeDict = builder.comment("Determines if the biome dictionary make assumptions for unregistered biomes. Setting this to false can fix issues where a structure generates in the wrong dimension.").define("biome_dictionary.make_best_guess", true);
            this.exceedFillLimit = builder.comment("When true, removes the size limit from the fill and clone commands.").define("commands.exceed_fill_clone_limit", true);
        }

        public boolean getExtraLakeProofing() {
            return (Boolean)this.extraLakeProofing.get();
        }

        public boolean shouldGuessBiomeDict() {
            return (Boolean)this.guessBiomeDict.get();
        }

        public List<String> getIgnoredMods() {
            return Arrays.stream(((String)this.ignoredMods.get()).split(",")).map(String::trim).collect(Collectors.toList());
        }

        public boolean shouldExceedFillLimit() {
            return (Boolean)this.exceedFillLimit.get();
        }
    }
}

