/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return sb.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int length = string.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (!Character.isWhitespace(string.charAt(i2))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x2, JSONObject context, String name, boolean keepStrings) throws JSONException {
        String string;
        JSONObject jsonobject = null;
        Object token = x2.nextToken();
        if (token == BANG) {
            char c2 = x2.next();
            if (c2 == '-') {
                if (x2.next() == '-') {
                    x2.skipPast("-->");
                    return false;
                }
                x2.back();
            } else if (c2 == '[') {
                token = x2.nextToken();
                if ("CDATA".equals(token) && x2.next() == '[') {
                    String string2 = x2.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x2.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((token = x2.nextMeta()) == null) {
                    throw x2.syntaxError("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i2;
                    continue;
                }
                if (token != GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (token == QUEST) {
            x2.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            token = x2.nextToken();
            if (name == null) {
                throw x2.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x2.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x2.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        jsonobject = new JSONObject();
        while (true) {
            if (token == null) {
                token = x2.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x2.nextToken();
            if (token == EQ) {
                token = x2.nextToken();
                if (!(token instanceof String)) {
                    throw x2.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, keepStrings ? token : JSONObject.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == SLASH) {
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped tag");
            }
            if (jsonobject.length() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = x2.nextContent()) == null) {
                    if (tagName != null) {
                        throw x2.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.accumulate("content", keepStrings ? token : JSONObject.stringToValue(string));
                    continue;
                }
                if (token == LT && XML.parse(x2, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.length() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.length() == 1 && jsonobject.opt("content") != null) {
                context.accumulate(tagName, jsonobject.opt("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x2.syntaxError("Misshaped tag");
    }

    @Deprecated
    public static Object stringToValue(String string) {
        return JSONObject.stringToValue(string);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return XML.toJSONObject(string, false);
    }

    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        JSONObject jo = new JSONObject();
        XMLTokener x2 = new XMLTokener(string);
        while (x2.more() && x2.skipPast("<")) {
            XML.parse(x2, jo, null, keepStrings);
        }
        return jo;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JSONException {
        String string;
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JSONObject jo = (JSONObject)object;
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                JSONArray ja;
                String string2;
                String key = keys.next();
                Object value = jo.opt(key);
                if (value == null) {
                    value = "";
                } else if (value.getClass().isArray()) {
                    value = new JSONArray(value);
                }
                String string3 = string2 = value instanceof String ? (String)value : null;
                if ("content".equals(key)) {
                    if (value instanceof JSONArray) {
                        ja = (JSONArray)value;
                        int i2 = 0;
                        for (Object val : ja) {
                            if (i2 > 0) {
                                sb.append('\n');
                            }
                            sb.append(XML.escape(val.toString()));
                            ++i2;
                        }
                        continue;
                    }
                    sb.append(XML.escape(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    ja = (JSONArray)value;
                    for (Object val : ja) {
                        if (val instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toString(val));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toString(val, key));
                    }
                    continue;
                }
                if ("".equals(value)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XML.toString(value, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object != null) {
            if (object.getClass().isArray()) {
                object = new JSONArray(object);
            }
            if (object instanceof JSONArray) {
                JSONArray ja = (JSONArray)object;
                for (Object val : ja) {
                    sb.append(XML.toString(val, tagName == null ? "array" : tagName));
                }
                return sb.toString();
            }
        }
        String string4 = string = object == null ? "null" : XML.escape(object.toString());
        return tagName == null ? "\"" + string + "\"" : (string.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string + "</" + tagName + ">");
    }
}

