/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Protocol;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.Ping;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class Http2Connection
implements Closeable {
    static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    boolean shutdown;
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    boolean receivedInitialPeerSettings = false;
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    Http2Connection(Builder builder) {
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n2 = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        int n3 = this.nextPingId = builder.client ? 1 : 2;
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.hostname = builder.hostname;
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.hostname), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, this.client));
    }

    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized Http2Stream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized Http2Stream removeStream(int streamId) {
        Http2Stream stream = this.streams.remove(streamId);
        this.notifyAll();
        return stream;
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public Http2Stream pushStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        return this.newStream(associatedStreamId, requestHeaders, out);
    }

    public Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean flushHeaders;
        Http2Stream stream;
        boolean outFinished = !out;
        boolean inFinished = false;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int streamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, inFinished, requestHeaders);
                boolean bl = flushHeaders = !out || this.bytesLeftInWriteWindow == 0L || stream.bytesLeftInWriteWindow == 0L;
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
            }
            if (associatedStreamId == 0) {
                this.writer.synStream(outFinished, streamId, associatedStreamId, requestHeaders);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    void writeSynReply(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        this.writer.synReply(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        while (byteCount > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount, this.bytesLeftInWriteWindow);
                toWrite = Math.min(toWrite, this.writer.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int streamId, final ErrorCode errorCode) {
        executor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostname, streamId}){

            @Override
            public void execute() {
                try {
                    Http2Connection.this.writeSynReset(streamId, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, ErrorCode statusCode) throws IOException {
        this.writer.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final long unacknowledgedBytesRead) {
        executor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostname, streamId}){

            @Override
            public void execute() {
                try {
                    Http2Connection.this.writer.windowUpdate(streamId, unacknowledgedBytesRead);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.shutdown) {
                throw new ConnectionShutdownException();
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new LinkedHashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(false, pingId, 1330343787, ping);
        return ping;
    }

    void writePingLater(final boolean reply, final int payload1, final int payload2, final Ping ping) {
        executor.execute(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostname, payload1, payload2}){

            @Override
            public void execute() {
                try {
                    Http2Connection.this.writePing(reply, payload1, payload2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            if (ping != null) {
                ping.send();
            }
            this.writer.ping(reply, payload1, payload2);
        }
    }

    synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode statusCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int lastGoodStreamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.writer.goAway(lastGoodStreamId, statusCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ErrorCode connectionCode, ErrorCode streamCode) throws IOException {
        assert (!Thread.holdsLock(this));
        IOException thrown = null;
        try {
            this.shutdown(connectionCode);
        }
        catch (IOException e2) {
            thrown = e2;
        }
        Http2Stream[] streamsToClose = null;
        Ping[] pingsToCancel = null;
        Http2Stream[] http2StreamArray = this;
        synchronized (this) {
            block19: {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                    this.streams.clear();
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
                // ** MonitorExit[http2StreamArray] (shouldn't be in output)
                if (streamsToClose != null) {
                    for (Http2Stream http2Stream : streamsToClose) {
                        try {
                            http2Stream.close(streamCode);
                        }
                        catch (IOException e3) {
                            if (thrown == null) continue;
                            thrown = e3;
                        }
                    }
                }
                if (pingsToCancel != null) {
                    for (Http2Stream http2Stream : pingsToCancel) {
                        ((Ping)((Object)http2Stream)).cancel();
                    }
                }
                try {
                    this.writer.close();
                }
                catch (IOException e4) {
                    if (thrown != null) break block19;
                    thrown = e4;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e5) {
                thrown = e5;
            }
            if (thrown != null) {
                throw thrown;
            }
            return;
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean sendConnectionPreface) throws IOException {
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                this.writer.settings(settings);
            }
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    boolean pushedStream(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushRequestLater(final int streamId, final List<Header> requestHeaders) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostname, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block5: {
                    boolean cancel = Http2Connection.this.pushObserver.onRequest(streamId, requestHeaders);
                    try {
                        if (!cancel) break block5;
                        Http2Connection.this.writer.rstStream(streamId, ErrorCode.CANCEL);
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void pushHeadersLater(final int streamId, final List<Header> requestHeaders, final boolean inFinished) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostname, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    boolean cancel = Http2Connection.this.pushObserver.onHeaders(streamId, requestHeaders, inFinished);
                    try {
                        if (cancel) {
                            Http2Connection.this.writer.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void pushDataLater(final int streamId, BufferedSource source, final int byteCount, final boolean inFinished) throws IOException {
        final Buffer buffer = new Buffer();
        source.require(byteCount);
        source.read(buffer, byteCount);
        if (buffer.size() != (long)byteCount) {
            throw new IOException(buffer.size() + " != " + byteCount);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostname, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean cancel = Http2Connection.this.pushObserver.onData(streamId, buffer, byteCount, inFinished);
                        if (cancel) {
                            Http2Connection.this.writer.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void pushResetLater(final int streamId, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostname, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Http2Connection.this.pushObserver.onReset(streamId, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(streamId);
                }
            }
        });
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream stream) throws IOException {
                stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader reader) {
            super("OkHttp %s", Http2Connection.this.hostname);
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e2) {
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    Http2Connection.this.close(connectionErrorCode, streamErrorCode);
                }
                catch (IOException iOException) {}
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            if (Http2Connection.this.pushedStream(streamId)) {
                Http2Connection.this.pushDataLater(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater(streamId, ErrorCode.PROTOCOL_ERROR);
                source.skip(length);
                return;
            }
            dataStream.receiveData(source, length);
            if (inFinished) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock) {
            Http2Stream stream;
            if (Http2Connection.this.pushedStream(streamId)) {
                Http2Connection.this.pushHeadersLater(streamId, headerBlock, inFinished);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                if (Http2Connection.this.shutdown) {
                    return;
                }
                stream = Http2Connection.this.getStream(streamId);
                if (stream == null) {
                    if (streamId <= Http2Connection.this.lastGoodStreamId) {
                        return;
                    }
                    if (streamId % 2 == Http2Connection.this.nextStreamId % 2) {
                        return;
                    }
                    final Http2Stream newStream = new Http2Stream(streamId, Http2Connection.this, false, inFinished, headerBlock);
                    Http2Connection.this.lastGoodStreamId = streamId;
                    Http2Connection.this.streams.put(streamId, newStream);
                    executor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{Http2Connection.this.hostname, streamId}){

                        @Override
                        public void execute() {
                            try {
                                Http2Connection.this.listener.onStream(newStream);
                            }
                            catch (IOException e2) {
                                Platform.get().log(4, "Http2Connection.Listener failure for " + Http2Connection.this.hostname, e2);
                                try {
                                    newStream.close(ErrorCode.PROTOCOL_ERROR);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            stream.receiveHeaders(headerBlock);
            if (inFinished) {
                stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(streamId)) {
                Http2Connection.this.pushResetLater(streamId, errorCode);
                return;
            }
            Http2Stream rstStream = Http2Connection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings newSettings) {
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                int priorWriteWindowSize = Http2Connection.this.peerSettings.getInitialWindowSize();
                if (clearPrevious) {
                    Http2Connection.this.peerSettings.clear();
                }
                Http2Connection.this.peerSettings.merge(newSettings);
                this.applyAndAckSettings(newSettings);
                int peerInitialWindowSize = Http2Connection.this.peerSettings.getInitialWindowSize();
                if (peerInitialWindowSize != -1 && peerInitialWindowSize != priorWriteWindowSize) {
                    delta = peerInitialWindowSize - priorWriteWindowSize;
                    if (!Http2Connection.this.receivedInitialPeerSettings) {
                        Http2Connection.this.addBytesToWriteWindow(delta);
                        Http2Connection.this.receivedInitialPeerSettings = true;
                    }
                    if (!Http2Connection.this.streams.isEmpty()) {
                        streamsToNotify = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                    }
                }
                executor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{Http2Connection.this.hostname}){

                    @Override
                    public void execute() {
                        Http2Connection.this.listener.onSettings(Http2Connection.this);
                    }
                });
            }
            if (streamsToNotify != null && delta != 0L) {
                http2Connection = streamsToNotify;
                int n2 = ((Http2Connection)http2Connection).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Http2Connection stream;
                    Http2Connection http2Connection2 = stream = http2Connection[i2];
                    synchronized (http2Connection2) {
                        ((Http2Stream)((Object)stream)).addBytesToWriteWindow(delta);
                        continue;
                    }
                }
            }
        }

        private void applyAndAckSettings(final Settings peerSettings) {
            executor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{Http2Connection.this.hostname}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writer.applyAndAckSettings(peerSettings);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void ping(boolean reply, int payload1, int payload2) {
            if (reply) {
                Ping ping = Http2Connection.this.removePing(payload1);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                Http2Connection.this.writePingLater(true, payload1, payload2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] http2StreamArray = Http2Connection.this;
            synchronized (Http2Connection.this) {
                Http2Stream[] streamsCopy = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.this.shutdown = true;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                for (Http2Stream http2Stream : streamsCopy) {
                    if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                    http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(http2Stream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.bytesLeftInWriteWindow += windowSizeIncrement;
                    Http2Connection.this.notifyAll();
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            Http2Connection.this.pushRequestLater(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }

    public static class Builder {
        Socket socket;
        String hostname;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;

        public Builder(boolean client) {
            this.client = client;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String hostname, BufferedSource source, BufferedSink sink) {
            this.socket = socket;
            this.hostname = hostname;
            this.source = source;
            this.sink = sink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Http2Connection build() throws IOException {
            return new Http2Connection(this);
        }
    }
}

