/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class RouteException
extends RuntimeException {
    private static final Method addSuppressedExceptionMethod;
    private IOException lastException;

    public RouteException(IOException cause) {
        super(cause);
        this.lastException = cause;
    }

    public IOException getLastConnectException() {
        return this.lastException;
    }

    public void addConnectException(IOException e2) {
        this.addSuppressedIfPossible(e2, this.lastException);
        this.lastException = e2;
    }

    private void addSuppressedIfPossible(IOException e2, IOException suppressed) {
        if (addSuppressedExceptionMethod != null) {
            try {
                addSuppressedExceptionMethod.invoke((Object)e2, suppressed);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static {
        Method m2;
        try {
            m2 = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception e2) {
            m2 = null;
        }
        addSuppressedExceptionMethod = m2;
    }
}

