/*
 * Decompiled with CFR 0.152.
 */
package net.decimation.mod.utilities.ping;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Calendar;
import net.decimation.mod.utilities.ping.MinecraftPingOptions;
import net.decimation.mod.utilities.ping.MinecraftPingReply;
import net.decimation.mod.utilities.ping.MinecraftPingUtil;
import net.minecraft.util.IChatComponent;

public class MinecraftPing {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)IChatComponent.class), new IChatComponent.Serializer()).create();

    public MinecraftPingReply getPing(String string) throws IOException {
        return this.getPing(new MinecraftPingOptions().setHostname(string));
    }

    public MinecraftPingReply getPing(String string, int n2) throws IOException {
        return this.getPing(new MinecraftPingOptions().setHostname(string).setPort(n2));
    }

    public MinecraftPingReply getPing(MinecraftPingOptions minecraftPingOptions) throws IOException {
        MinecraftPingUtil.validate(minecraftPingOptions.getHostname(), "Hostname cannot be null.");
        MinecraftPingUtil.validate(minecraftPingOptions.getPort(), "Port cannot be null.");
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(minecraftPingOptions.getHostname(), minecraftPingOptions.getPort()), minecraftPingOptions.getTimeout());
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeByte(MinecraftPingUtil.PACKET_HANDSHAKE);
        MinecraftPingUtil.writeVarInt(dataOutputStream2, MinecraftPingUtil.PROTOCOL_VERSION);
        MinecraftPingUtil.writeVarInt(dataOutputStream2, minecraftPingOptions.getHostname().length());
        dataOutputStream2.writeBytes(minecraftPingOptions.getHostname());
        dataOutputStream2.writeShort(minecraftPingOptions.getPort());
        MinecraftPingUtil.writeVarInt(dataOutputStream2, MinecraftPingUtil.STATUS_HANDSHAKE);
        MinecraftPingUtil.writeVarInt(dataOutputStream, byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(MinecraftPingUtil.PACKET_STATUSREQUEST);
        long l2 = Calendar.getInstance().getTime().getTime();
        MinecraftPingUtil.readVarInt(dataInputStream);
        int n2 = MinecraftPingUtil.readVarInt(dataInputStream);
        MinecraftPingUtil.io(n2 == -1, "Server prematurely ended stream.");
        MinecraftPingUtil.io(n2 != MinecraftPingUtil.PACKET_STATUSREQUEST, "Server returned invalid packet.");
        int n3 = MinecraftPingUtil.readVarInt(dataInputStream);
        MinecraftPingUtil.io(n3 == -1, "Server prematurely ended stream.");
        MinecraftPingUtil.io(n3 == 0, "Server returned unexpected value.");
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, minecraftPingOptions.getCharset());
        dataOutputStream.writeByte(9);
        dataOutputStream.writeByte(MinecraftPingUtil.PACKET_PING);
        dataOutputStream.writeLong(System.currentTimeMillis());
        long l3 = Calendar.getInstance().getTime().getTime();
        MinecraftPingUtil.readVarInt(dataInputStream);
        n2 = MinecraftPingUtil.readVarInt(dataInputStream);
        MinecraftPingUtil.io(n2 == -1, "Server prematurely ended stream.");
        MinecraftPingUtil.io(n2 != MinecraftPingUtil.PACKET_PING, "Server returned invalid packet.");
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        dataOutputStream.close();
        dataInputStream.close();
        socket.close();
        MinecraftPingReply minecraftPingReply = GSON.fromJson(string, MinecraftPingReply.class);
        minecraftPingReply.setPing((l3 - l2) / 4L);
        return minecraftPingReply;
    }
}

