/*
 * Decompiled with CFR 0.152.
 */
package net.decimation.mod.server.clans.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import deci.Q.b;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.decimation.mod.server.clans.v2.Clan;
import net.decimation.mod.server.turf.a;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ClanManager {
    public static String UNKNOWN_CLAN = "unknown";
    public static String clansDir = "clans/";
    private final a turfManager;
    private final HashMap<String, Clan> clans;
    public Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public ClanManager(a a2) {
        this.turfManager = a2;
        this.clans = new HashMap();
    }

    public static void broadcast(String string) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(string));
    }

    public Clan getClanFromName(String string) {
        if (string != null && string.length() > 0) {
            if (!this.clans.containsKey(string)) {
                try {
                    this.clans.put(string, this.getClanFromFile(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return this.clans.get(string);
        }
        return null;
    }

    private Clan getClanFromFile(String string) throws IOException {
        File file = this.clanFile(string);
        ClanManager.broadcast("#DEBUG - GETTING CLAN FROM FILE");
        if (file.exists()) {
            ClanManager.broadcast("#DEBUG - CLAN EXIST");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Clan clan = this.gson.fromJson((Reader)bufferedReader, Clan.class);
            clan.setName(string);
            bufferedReader.close();
            return clan;
        }
        ClanManager.broadcast("#DEBUG - CLAN NOT EXIST");
        return null;
    }

    public List<Clan> getClansFromFiles() throws IOException {
        File[] fileArray;
        ArrayList<Clan> arrayList = new ArrayList<Clan>();
        for (File file : fileArray = new File(clansDir).listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".json") || !file.exists()) continue;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            arrayList.add(new Gson().fromJson((Reader)bufferedReader, Clan.class));
        }
        return arrayList;
    }

    public List<Clan> getClans() {
        ArrayList<Clan> arrayList = new ArrayList<Clan>();
        if (!this.clans.isEmpty()) {
            for (Clan clan : this.clans.values()) {
                arrayList.add(clan);
            }
        }
        return arrayList;
    }

    public Clan getClanFromPlayer(EntityPlayer entityPlayer) {
        b b2 = new b(entityPlayer);
        Clan clan = this.getClanFromName(b2.cY());
        return clan;
    }

    public boolean removeClan(Clan clan, EntityPlayer entityPlayer) {
        if (this.clanFileExist(clan.getName()) && this.clanExistInCache(clan.getName())) {
            for (UUID uUID : clan.getPlayers()) {
                b b2;
                clan.removeMember(uUID);
                EntityPlayer entityPlayer2 = entityPlayer.field_70170_p.func_152378_a(uUID);
                if (entityPlayer2 == null || (b2 = b.e(entityPlayer2)) == null) continue;
                b2.B(UNKNOWN_CLAN);
            }
            this.clans.remove(clan);
            this.clanFile(clan.getName()).delete();
            return true;
        }
        return false;
    }

    public boolean isPlayerInClan(EntityPlayer entityPlayer) {
        b b2 = b.e(entityPlayer);
        if (b2 != null) {
            if (b2.cY().equalsIgnoreCase(UNKNOWN_CLAN) || b2.cY().length() <= 0 || b2.cY() == null) {
                return false;
            }
            if (this.getClanFromPlayer(entityPlayer) == null) {
                return false;
            }
            return b2.cY() != null && !b2.cY().equalsIgnoreCase(UNKNOWN_CLAN) && b2.cY().length() > 0;
        }
        return false;
    }

    public boolean doesClanHaveClanAsEnemy(String string, String string2) throws IOException {
        if (this.clanFileExist(string)) {
            Clan clan = this.getClanFromName(string);
            return clan.getEnemies().contains(string2) && this.clanFileExist(string2);
        }
        return false;
    }

    public boolean doesClanHaveClanAsAlly(String string, String string2) throws IOException {
        if (this.clanFileExist(string)) {
            Clan clan = this.getClanFromName(string);
            return clan.getAllies().contains(string2) && this.clanFileExist(string2);
        }
        return false;
    }

    public boolean createClan(String string, EntityPlayer entityPlayer) throws IOException {
        if (!this.clanFileExist(string) && !this.clanExistInCache(string)) {
            Clan clan = new Clan(string, entityPlayer);
            this.clans.put(string, clan);
            return true;
        }
        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("The clan " + EnumChatFormatting.RED + string + EnumChatFormatting.RESET + " already exists!"));
        return false;
    }

    public File clanFile(String string) {
        return new File(clansDir + string.toLowerCase() + ".json");
    }

    public boolean clanFileExist(String string) {
        File file = this.clanFile(string);
        return file.exists() && file.length() > 0L;
    }

    public boolean clanExistInCache(String string) {
        return this.clans.containsKey(string);
    }
}

