/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntPredicate;

public final class ShortIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private ShortIterators() {
    }

    public static ShortListIterator singleton(short element) {
        return new SingletonIterator(element);
    }

    public static ShortListIterator wrap(short[] array, int offset, int length) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static ShortListIterator wrap(short[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(ShortIterator i2, short[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            array[offset++] = i2.nextShort();
        }
        return max - j2 - 1;
    }

    public static int unwrap(ShortIterator i2, short[] array) {
        return ShortIterators.unwrap(i2, array, 0, array.length);
    }

    public static short[] unwrap(ShortIterator i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        short[] array = new short[16];
        int j2 = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j2 == array.length) {
                array = ShortArrays.grow(array, j2 + 1);
            }
            array[j2++] = i2.nextShort();
        }
        return ShortArrays.trim(array, j2);
    }

    public static short[] unwrap(ShortIterator i2) {
        return ShortIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static int unwrap(ShortIterator i2, ShortCollection c2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            c2.add(i2.nextShort());
        }
        return max - j2 - 1;
    }

    public static long unwrap(ShortIterator i2, ShortCollection c2) {
        long n2 = 0L;
        while (i2.hasNext()) {
            c2.add(i2.nextShort());
            ++n2;
        }
        return n2;
    }

    public static int pour(ShortIterator i2, ShortCollection s2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            s2.add(i2.nextShort());
        }
        return max - j2 - 1;
    }

    public static int pour(ShortIterator i2, ShortCollection s2) {
        return ShortIterators.pour(i2, s2, Integer.MAX_VALUE);
    }

    public static ShortList pour(ShortIterator i2, int max) {
        ShortArrayList l2 = new ShortArrayList();
        ShortIterators.pour(i2, l2, max);
        l2.trim();
        return l2;
    }

    public static ShortList pour(ShortIterator i2) {
        return ShortIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static ShortIterator asShortIterator(Iterator i2) {
        if (i2 instanceof ShortIterator) {
            return (ShortIterator)i2;
        }
        return new IteratorWrapper(i2);
    }

    public static ShortListIterator asShortIterator(ListIterator i2) {
        if (i2 instanceof ShortListIterator) {
            return (ShortListIterator)i2;
        }
        return new ListIteratorWrapper(i2);
    }

    public static boolean any(ShortIterator iterator, IntPredicate predicate) {
        return ShortIterators.indexOf(iterator, predicate) != -1;
    }

    public static boolean all(ShortIterator iterator, IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (predicate.test(iterator.nextShort()));
        return false;
    }

    public static int indexOf(ShortIterator iterator, IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        int i2 = 0;
        while (iterator.hasNext()) {
            if (predicate.test(iterator.nextShort())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static ShortListIterator fromTo(short from, short to) {
        return new IntervalIterator(from, to);
    }

    public static ShortIterator concat(ShortIterator[] a2) {
        return ShortIterators.concat(a2, 0, a2.length);
    }

    public static ShortIterator concat(ShortIterator[] a2, int offset, int length) {
        return new IteratorConcatenator(a2, offset, length);
    }

    public static ShortIterator unmodifiable(ShortIterator i2) {
        return new UnmodifiableIterator(i2);
    }

    public static ShortBidirectionalIterator unmodifiable(ShortBidirectionalIterator i2) {
        return new UnmodifiableBidirectionalIterator(i2);
    }

    public static ShortListIterator unmodifiable(ShortListIterator i2) {
        return new UnmodifiableListIterator(i2);
    }

    public static ShortIterator wrap(ByteIterator iterator) {
        return new ByteIteratorWrapper(iterator);
    }

    protected static class ByteIteratorWrapper
    implements ShortIterator {
        final ByteIterator iterator;

        public ByteIteratorWrapper(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Short next() {
            return this.iterator.nextByte();
        }

        @Override
        public short nextShort() {
            return this.iterator.nextByte();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    public static class UnmodifiableListIterator
    implements ShortListIterator {
        protected final ShortListIterator i;

        public UnmodifiableListIterator(ShortListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public short nextShort() {
            return this.i.nextShort();
        }

        @Override
        public short previousShort() {
            return this.i.previousShort();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    implements ShortBidirectionalIterator {
        protected final ShortBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(ShortBidirectionalIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public short nextShort() {
            return this.i.nextShort();
        }

        @Override
        public short previousShort() {
            return this.i.previousShort();
        }
    }

    public static class UnmodifiableIterator
    implements ShortIterator {
        protected final ShortIterator i;

        public UnmodifiableIterator(ShortIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public short nextShort() {
            return this.i.nextShort();
        }
    }

    private static class IteratorConcatenator
    implements ShortIterator {
        final ShortIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(ShortIterator[] a2, int offset, int length) {
            this.a = a2;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            short next = this.a[this.lastOffset].nextShort();
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n2) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n2 && this.length != 0) {
                skipped += this.a[this.offset].skip(n2 - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class IntervalIterator
    implements ShortListIterator {
        private final short from;
        private final short to;
        short curr;

        public IntervalIterator(short from, short to) {
            this.from = this.curr = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.to;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > this.from;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s2 = this.curr;
            this.curr = (short)(s2 + 1);
            return s2;
        }

        @Override
        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = (short)(this.curr - 1);
            return this.curr;
        }

        @Override
        public int nextIndex() {
            return this.curr - this.from;
        }

        @Override
        public int previousIndex() {
            return this.curr - this.from - 1;
        }

        @Override
        public int skip(int n2) {
            if (this.curr + n2 <= this.to) {
                this.curr = (short)(this.curr + n2);
                return n2;
            }
            n2 = this.to - this.curr;
            this.curr = this.to;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (this.curr - n2 >= this.from) {
                this.curr = (short)(this.curr - n2);
                return n2;
            }
            n2 = this.curr - this.from;
            this.curr = this.from;
            return n2;
        }
    }

    private static class ListIteratorWrapper
    implements ShortListIterator {
        final ListIterator<Short> i;

        public ListIteratorWrapper(ListIterator<Short> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(short k2) {
            this.i.set(k2);
        }

        @Override
        public void add(short k2) {
            this.i.add(k2);
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public short nextShort() {
            return this.i.next();
        }

        @Override
        public short previousShort() {
            return this.i.previous();
        }
    }

    private static class IteratorWrapper
    implements ShortIterator {
        final Iterator<Short> i;

        public IteratorWrapper(Iterator<Short> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public short nextShort() {
            return this.i.next();
        }
    }

    private static class ArrayIterator
    implements ShortListIterator {
        private final short[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(short[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public int skip(int n2) {
            if (n2 <= this.length - this.curr) {
                this.curr += n2;
                return n2;
            }
            n2 = this.length - this.curr;
            this.curr = this.length;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (n2 <= this.curr) {
                this.curr -= n2;
                return n2;
            }
            n2 = this.curr;
            this.curr = 0;
            return n2;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class SingletonIterator
    implements ShortListIterator {
        private final short element;
        private int curr;

        public SingletonIterator(short element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyIterator
    implements ShortListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public short nextShort() {
            throw new NoSuchElementException();
        }

        @Override
        public short previousShort() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n2) {
            return 0;
        }

        @Override
        public int back(int n2) {
            return 0;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }
}

