/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class ShortComparators {
    public static final ShortComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ShortComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private ShortComparators() {
    }

    public static ShortComparator oppositeComparator(ShortComparator c2) {
        return new OppositeComparator(c2);
    }

    public static ShortComparator asShortComparator(final Comparator<? super Short> c2) {
        if (c2 == null || c2 instanceof ShortComparator) {
            return (ShortComparator)c2;
        }
        return new ShortComparator(){

            @Override
            public int compare(short x2, short y2) {
                return c2.compare(x2, y2);
            }

            @Override
            public int compare(Short x2, Short y2) {
                return c2.compare(x2, y2);
            }
        };
    }

    protected static class OppositeComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ShortComparator comparator;

        protected OppositeComparator(ShortComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(short a2, short b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(short a2, short b2) {
            return -Short.compare(a2, b2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(short a2, short b2) {
            return Short.compare(a2, b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

