/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.shorts.AbstractShortBigList;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigList;
import it.unimi.dsi.fastutil.shorts.ShortBigListIterator;
import it.unimi.dsi.fastutil.shorts.ShortBigListIterators;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public final class ShortBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private ShortBigLists() {
    }

    public static ShortBigList shuffle(ShortBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            short t2 = l2.getShort(i2);
            l2.set(i2, l2.getShort(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static ShortBigList singleton(short element) {
        return new Singleton(element);
    }

    public static ShortBigList singleton(Object element) {
        return new Singleton((Short)element);
    }

    public static ShortBigList synchronize(ShortBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static ShortBigList synchronize(ShortBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static ShortBigList unmodifiable(ShortBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static ShortBigList asBigList(ShortList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractShortBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final ShortList list;

        protected ListBigList(ShortList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public ShortBigListIterator iterator() {
            return ShortBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public ShortBigListIterator listIterator() {
            return ShortBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public ShortBigListIterator listIterator(long index) {
            return ShortBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Short> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public ShortBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(short key) {
            return this.list.contains(key);
        }

        @Override
        public short[] toShortArray() {
            return this.list.toShortArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public short[] toShortArray(short[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, ShortCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(ShortCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, ShortBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(ShortBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(ShortCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(ShortCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(ShortCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, short key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(short key) {
            return this.list.add(key);
        }

        @Override
        public short getShort(long index) {
            return this.list.getShort(this.intIndex(index));
        }

        @Override
        public long indexOf(short k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(short k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public short removeShort(long index) {
            return this.list.removeShort(this.intIndex(index));
        }

        @Override
        public short set(long index, short k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Short> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends ShortCollections.UnmodifiableCollection
    implements ShortBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortBigList list;

        protected UnmodifiableBigList(ShortBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public short getShort(long i2) {
            return this.list.getShort(i2);
        }

        @Override
        public short set(long i2, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(short k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(short k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, short[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, short[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, short[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public ShortBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public ShortBigListIterator listIterator() {
            return ShortBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public ShortBigListIterator listIterator(long i2) {
            return ShortBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public ShortBigList subList(long from, long to) {
            return ShortBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Short> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, ShortBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short set(long index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends ShortCollections.SynchronizedCollection
    implements ShortBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortBigList list;

        protected SynchronizedBigList(ShortBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(ShortBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getShort(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getShort(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short set(long i2, short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, short k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short removeShort(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeShort(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Short> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, short[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, short[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, short[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public ShortBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public ShortBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ShortBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return ShortBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Short> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, ShortCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, ShortBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(ShortBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Short k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short set(long index, Short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractShortBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final short element;

        protected Singleton(short element) {
            this.element = element;
        }

        @Override
        public short getShort(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(short k2) {
            return k2 == this.element;
        }

        @Override
        public short[] toShortArray() {
            short[] a2 = new short[]{this.element};
            return a2;
        }

        @Override
        public ShortBigListIterator listIterator() {
            return ShortBigListIterators.singleton(this.element);
        }

        @Override
        public ShortBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            ShortBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextShort();
            }
            return l2;
        }

        @Override
        public ShortBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, ShortBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends ShortCollections.EmptyCollection
    implements ShortBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public short getShort(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short set(long index, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(short k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(short k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, ShortBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Short set(long index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public ShortBigListIterator listIterator() {
            return ShortBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public ShortBigListIterator iterator() {
            return ShortBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public ShortBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return ShortBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public ShortBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, short[][] a2, long offset, long length) {
            ShortBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, short[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, short[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Short> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

