/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ShortArrayFrontCodedList
extends AbstractObjectList<short[]>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    protected final int n;
    protected final int ratio;
    protected final short[][] array;
    protected transient long[] p;

    public ShortArrayFrontCodedList(Iterator<short[]> arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        short[][] array = ShortBigArrays.EMPTY_BIG_ARRAY;
        long[] p2 = LongArrays.EMPTY_ARRAY;
        short[][] a2 = new short[2][];
        long curSize = 0L;
        int n2 = 0;
        int b2 = 0;
        while (arrays.hasNext()) {
            a2[b2] = arrays.next();
            int length = a2[b2].length;
            if (n2 % ratio == 0) {
                p2 = LongArrays.grow(p2, n2 / ratio + 1);
                p2[n2 / ratio] = curSize;
                array = ShortBigArrays.grow(array, curSize + (long)ShortArrayFrontCodedList.count(length) + (long)length, curSize);
                curSize += (long)ShortArrayFrontCodedList.writeInt(array, length, curSize);
                ShortBigArrays.copyToBig(a2[b2], 0, array, curSize, length);
                curSize += (long)length;
            } else {
                int common;
                int minLength = a2[1 - b2].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a2[0][common] == a2[1][common]; ++common) {
                }
                array = ShortBigArrays.grow(array, curSize + (long)ShortArrayFrontCodedList.count(length -= common) + (long)ShortArrayFrontCodedList.count(common) + (long)length, curSize);
                curSize += (long)ShortArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += (long)ShortArrayFrontCodedList.writeInt(array, common, curSize);
                ShortBigArrays.copyToBig(a2[b2], common, array, curSize, length);
                curSize += (long)length;
            }
            b2 = 1 - b2;
            ++n2;
        }
        this.n = n2;
        this.ratio = ratio;
        this.array = ShortBigArrays.trim(array, curSize);
        this.p = LongArrays.trim(p2, (n2 + ratio - 1) / ratio);
    }

    public ShortArrayFrontCodedList(Collection<short[]> c2, int ratio) {
        this(c2.iterator(), ratio);
    }

    private static int readInt(short[][] a2, long pos) {
        int s0 = ShortBigArrays.get(a2, pos);
        return s0 >= 0 ? s0 : s0 << 16 | ShortBigArrays.get(a2, pos + 1L) & 0xFFFF;
    }

    private static int count(int length) {
        return length < 32768 ? 1 : 2;
    }

    private static int writeInt(short[][] a2, int length, long pos) {
        if (length < 32768) {
            ShortBigArrays.set(a2, pos, (short)length);
            return 1;
        }
        ShortBigArrays.set(a2, pos++, (short)(-(length >>> 16) - 1));
        ShortBigArrays.set(a2, pos, (short)(length & 0xFFFF));
        return 2;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        short[][] array = this.array;
        int delta = index % this.ratio;
        long pos = this.p[index / this.ratio];
        int length = ShortArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += (long)(ShortArrayFrontCodedList.count(length) + length);
        length = ShortArrayFrontCodedList.readInt(array, pos);
        int common = ShortArrayFrontCodedList.readInt(array, pos + (long)ShortArrayFrontCodedList.count(length));
        for (int i2 = 0; i2 < delta - 1; ++i2) {
            length = ShortArrayFrontCodedList.readInt(array, pos += (long)(ShortArrayFrontCodedList.count(length) + ShortArrayFrontCodedList.count(common) + length));
            common = ShortArrayFrontCodedList.readInt(array, pos + (long)ShortArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, short[] a2, int offset, int length) {
        long startPos;
        int delta = index % this.ratio;
        long pos = startPos = this.p[index / this.ratio];
        int arrayLength = ShortArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + (long)ShortArrayFrontCodedList.count(arrayLength);
            ShortBigArrays.copyFromBig(this.array, pos, a2, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i2 = 0; i2 < delta; ++i2) {
            long prevArrayPos = pos + (long)ShortArrayFrontCodedList.count(arrayLength) + (long)(i2 != 0 ? ShortArrayFrontCodedList.count(common) : 0);
            common = ShortArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + (long)arrayLength) + (long)ShortArrayFrontCodedList.count(arrayLength = ShortArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            ShortBigArrays.copyFromBig(this.array, prevArrayPos, a2, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            ShortBigArrays.copyFromBig(this.array, pos + (long)ShortArrayFrontCodedList.count(arrayLength) + (long)ShortArrayFrontCodedList.count(common), a2, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    @Override
    public short[] get(int index) {
        return this.getArray(index);
    }

    public short[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        short[] a2 = new short[length];
        this.extract(index, a2, 0, length);
        return a2;
    }

    public int get(int index, short[] a2, int offset, int length) {
        this.ensureRestrictedIndex(index);
        ShortArrays.ensureOffsetLength(a2, offset, length);
        int arrayLength = this.extract(index, a2, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, short[] a2) {
        return this.get(index, a2, 0, a2.length);
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public ObjectListIterator<short[]> listIterator(final int start) {
        this.ensureIndex(start);
        return new ObjectListIterator<short[]>(){
            short[] s = ShortArrays.EMPTY_ARRAY;
            int i = 0;
            long pos = 0L;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == ShortArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = ShortArrayFrontCodedList.this.p[start / ShortArrayFrontCodedList.this.ratio];
                        int j2 = start % ShortArrayFrontCodedList.this.ratio;
                        this.i = start - j2;
                        while (j2-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < ShortArrayFrontCodedList.this.n;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public short[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % ShortArrayFrontCodedList.this.ratio == 0) {
                    this.pos = ShortArrayFrontCodedList.this.p[this.i / ShortArrayFrontCodedList.this.ratio];
                    length = ShortArrayFrontCodedList.readInt(ShortArrayFrontCodedList.this.array, this.pos);
                    this.s = ShortArrays.ensureCapacity(this.s, length, 0);
                    ShortBigArrays.copyFromBig(ShortArrayFrontCodedList.this.array, this.pos + (long)ShortArrayFrontCodedList.count(length), this.s, 0, length);
                    this.pos += (long)(length + ShortArrayFrontCodedList.count(length));
                    this.inSync = true;
                } else if (this.inSync) {
                    length = ShortArrayFrontCodedList.readInt(ShortArrayFrontCodedList.this.array, this.pos);
                    int common = ShortArrayFrontCodedList.readInt(ShortArrayFrontCodedList.this.array, this.pos + (long)ShortArrayFrontCodedList.count(length));
                    this.s = ShortArrays.ensureCapacity(this.s, length + common, common);
                    ShortBigArrays.copyFromBig(ShortArrayFrontCodedList.this.array, this.pos + (long)ShortArrayFrontCodedList.count(length) + (long)ShortArrayFrontCodedList.count(common), this.s, common, length);
                    this.pos += (long)(ShortArrayFrontCodedList.count(length) + ShortArrayFrontCodedList.count(common) + length);
                    length += common;
                } else {
                    length = ShortArrayFrontCodedList.this.length(this.i);
                    this.s = ShortArrays.ensureCapacity(this.s, length, 0);
                    ShortArrayFrontCodedList.this.extract(this.i, this.s, 0, length);
                }
                ++this.i;
                return ShortArrays.copy(this.s, 0, length);
            }

            @Override
            public short[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return ShortArrayFrontCodedList.this.getArray(--this.i);
            }
        };
    }

    public ShortArrayFrontCodedList clone() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("[");
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (i2 != 0) {
                s2.append(", ");
            }
            s2.append(ShortArrayList.wrap(this.getArray(i2)).toString());
        }
        s2.append("]");
        return s2.toString();
    }

    protected long[] rebuildPointerArray() {
        long[] p2 = new long[(this.n + this.ratio - 1) / this.ratio];
        short[][] a2 = this.array;
        long pos = 0L;
        int j2 = 0;
        int skip = this.ratio - 1;
        for (int i2 = 0; i2 < this.n; ++i2) {
            int length = ShortArrayFrontCodedList.readInt(a2, pos);
            int count = ShortArrayFrontCodedList.count(length);
            if (++skip == this.ratio) {
                skip = 0;
                p2[j2++] = pos;
                pos += (long)(count + length);
                continue;
            }
            pos += (long)(count + ShortArrayFrontCodedList.count(ShortArrayFrontCodedList.readInt(a2, pos + (long)count)) + length);
        }
        return p2;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.p = this.rebuildPointerArray();
    }
}

