/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ByteMap;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ByteSortedMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparators;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class Short2ByteRBTreeMap
extends AbstractShort2ByteSortedMap
implements Serializable,
Cloneable {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected transient ObjectSortedSet<Short2ByteMap.Entry> entries;
    protected transient ShortSortedSet keys;
    protected transient ByteCollection values;
    protected transient boolean modified;
    protected Comparator<? super Short> storedComparator;
    protected transient ShortComparator actualComparator;
    private static final long serialVersionUID = -7046029254386353129L;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public Short2ByteRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = ShortComparators.asShortComparator(this.storedComparator);
    }

    public Short2ByteRBTreeMap(Comparator<? super Short> c2) {
        this();
        this.storedComparator = c2;
        this.setActualComparator();
    }

    public Short2ByteRBTreeMap(Map<? extends Short, ? extends Byte> m2) {
        this();
        this.putAll(m2);
    }

    public Short2ByteRBTreeMap(SortedMap<Short, Byte> m2) {
        this(m2.comparator());
        this.putAll((Map<? extends Short, ? extends Byte>)m2);
    }

    public Short2ByteRBTreeMap(Short2ByteMap m2) {
        this();
        this.putAll(m2);
    }

    public Short2ByteRBTreeMap(Short2ByteSortedMap m2) {
        this(m2.comparator());
        this.putAll(m2);
    }

    public Short2ByteRBTreeMap(short[] k2, byte[] v2, Comparator<? super Short> c2) {
        this(c2);
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    public Short2ByteRBTreeMap(short[] k2, byte[] v2) {
        this(k2, v2, null);
    }

    final int compare(short k1, short k2) {
        return this.actualComparator == null ? Short.compare(k1, k2) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(short k2) {
        int cmp;
        Entry e2 = this.tree;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return e2;
    }

    final Entry locateKey(short k2) {
        Entry e2 = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            last = e2;
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return cmp == 0 ? e2 : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    public byte addTo(short k2, byte incr) {
        Entry e2 = this.add(k2);
        byte oldValue = e2.value;
        e2.value = (byte)(e2.value + incr);
        return oldValue;
    }

    @Override
    public byte put(short k2, byte v2) {
        Entry e2 = this.add(k2);
        byte oldValue = e2.value;
        e2.value = v2;
        return oldValue;
    }

    private Entry add(short k2) {
        Entry e2;
        this.modified = false;
        int maxDepth = 0;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k2, this.defRetValue);
            this.tree = this.firstEntry;
            e2 = this.firstEntry;
        } else {
            Entry p2 = this.tree;
            int i2 = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k2, p2.key)) == 0) {
                    while (i2-- != 0) {
                        this.nodePath[i2] = null;
                    }
                    return p2;
                }
                this.nodePath[i2] = p2;
                this.dirPath[i2++] = cmp > 0;
                if (this.dirPath[i2++]) {
                    if (p2.succ()) {
                        ++this.count;
                        e2 = new Entry(k2, this.defRetValue);
                        if (p2.right == null) {
                            this.lastEntry = e2;
                        }
                        e2.left = p2;
                        e2.right = p2.right;
                        p2.right(e2);
                        break;
                    }
                    p2 = p2.right;
                    continue;
                }
                if (p2.pred()) {
                    ++this.count;
                    e2 = new Entry(k2, this.defRetValue);
                    if (p2.left == null) {
                        this.firstEntry = e2;
                    }
                    e2.right = p2;
                    e2.left = p2.left;
                    p2.left(e2);
                    break;
                }
                p2 = p2.left;
            }
            this.modified = true;
            maxDepth = i2--;
            while (i2 > 0 && !this.nodePath[i2].black()) {
                Entry x2;
                Entry y2;
                if (!this.dirPath[i2 - 1]) {
                    y2 = this.nodePath[i2 - 1].right;
                    if (!this.nodePath[i2 - 1].succ() && !y2.black()) {
                        this.nodePath[i2].black(true);
                        y2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        i2 -= 2;
                        continue;
                    }
                    if (!this.dirPath[i2]) {
                        y2 = this.nodePath[i2];
                    } else {
                        x2 = this.nodePath[i2];
                        y2 = x2.right;
                        x2.right = y2.left;
                        y2.left = x2;
                        this.nodePath[i2 - 1].left = y2;
                        if (y2.pred()) {
                            y2.pred(false);
                            x2.succ(y2);
                        }
                    }
                    x2 = this.nodePath[i2 - 1];
                    x2.black(false);
                    y2.black(true);
                    x2.left = y2.right;
                    y2.right = x2;
                    if (i2 < 2) {
                        this.tree = y2;
                    } else if (this.dirPath[i2 - 2]) {
                        this.nodePath[i2 - 2].right = y2;
                    } else {
                        this.nodePath[i2 - 2].left = y2;
                    }
                    if (!y2.succ()) break;
                    y2.succ(false);
                    x2.pred(y2);
                    break;
                }
                y2 = this.nodePath[i2 - 1].left;
                if (!this.nodePath[i2 - 1].pred() && !y2.black()) {
                    this.nodePath[i2].black(true);
                    y2.black(true);
                    this.nodePath[i2 - 1].black(false);
                    i2 -= 2;
                    continue;
                }
                if (this.dirPath[i2]) {
                    y2 = this.nodePath[i2];
                } else {
                    x2 = this.nodePath[i2];
                    y2 = x2.left;
                    x2.left = y2.right;
                    y2.right = x2;
                    this.nodePath[i2 - 1].right = y2;
                    if (y2.succ()) {
                        y2.succ(false);
                        x2.pred(y2);
                    }
                }
                x2 = this.nodePath[i2 - 1];
                x2.black(false);
                y2.black(true);
                x2.right = y2.left;
                y2.left = x2;
                if (i2 < 2) {
                    this.tree = y2;
                } else if (this.dirPath[i2 - 2]) {
                    this.nodePath[i2 - 2].right = y2;
                } else {
                    this.nodePath[i2 - 2].left = y2;
                }
                if (!y2.pred()) break;
                y2.pred(false);
                x2.succ(y2);
                break;
            }
        }
        this.tree.black(true);
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte remove(short k2) {
        int i2;
        Entry p2;
        block68: {
            Entry s2;
            int j2;
            boolean color;
            block74: {
                block69: {
                    Entry r2;
                    block73: {
                        block71: {
                            block72: {
                                block66: {
                                    block67: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return this.defRetValue;
                                        }
                                        p2 = this.tree;
                                        i2 = 0;
                                        short kk = k2;
                                        while (true) {
                                            int cmp;
                                            if ((cmp = this.compare(kk, p2.key)) == 0) {
                                                if (p2.left != null) break block66;
                                                break block67;
                                            }
                                            this.dirPath[i2] = cmp > 0;
                                            this.nodePath[i2] = p2;
                                            if (this.dirPath[i2++]) {
                                                if ((p2 = p2.right()) != null) continue;
                                                while (true) {
                                                    if (i2-- == 0) {
                                                        return this.defRetValue;
                                                    }
                                                    this.nodePath[i2] = null;
                                                }
                                            }
                                            if ((p2 = p2.left()) == null) break;
                                        }
                                        while (true) {
                                            if (i2-- == 0) {
                                                return this.defRetValue;
                                            }
                                            this.nodePath[i2] = null;
                                        }
                                    }
                                    this.firstEntry = p2.next();
                                }
                                if (p2.right == null) {
                                    this.lastEntry = p2.prev();
                                }
                                if (!p2.succ()) break block71;
                                if (!p2.pred()) break block72;
                                if (i2 == 0) {
                                    this.tree = p2.left;
                                    break block68;
                                } else if (this.dirPath[i2 - 1]) {
                                    this.nodePath[i2 - 1].succ(p2.right);
                                    break block68;
                                } else {
                                    this.nodePath[i2 - 1].pred(p2.left);
                                }
                                break block68;
                            }
                            p2.prev().right = p2.right;
                            if (i2 == 0) {
                                this.tree = p2.left;
                                break block68;
                            } else if (this.dirPath[i2 - 1]) {
                                this.nodePath[i2 - 1].right = p2.left;
                                break block68;
                            } else {
                                this.nodePath[i2 - 1].left = p2.left;
                            }
                            break block68;
                        }
                        r2 = p2.right;
                        if (!r2.pred()) break block73;
                        r2.left = p2.left;
                        r2.pred(p2.pred());
                        if (!r2.pred()) {
                            r2.prev().right = r2;
                        }
                        if (i2 == 0) {
                            this.tree = r2;
                        } else if (this.dirPath[i2 - 1]) {
                            this.nodePath[i2 - 1].right = r2;
                        } else {
                            this.nodePath[i2 - 1].left = r2;
                        }
                        color = r2.black();
                        r2.black(p2.black());
                        p2.black(color);
                        this.dirPath[i2] = true;
                        this.nodePath[i2++] = r2;
                        break block68;
                    }
                    j2 = i2++;
                    while (true) {
                        this.dirPath[i2] = false;
                        this.nodePath[i2++] = r2;
                        s2 = r2.left;
                        if (s2.pred()) {
                            this.dirPath[j2] = true;
                            this.nodePath[j2] = s2;
                            if (s2.succ()) {
                                break;
                            }
                            break block69;
                        }
                        r2 = s2;
                    }
                    r2.pred(s2);
                    break block74;
                }
                r2.left = s2.right;
            }
            s2.left = p2.left;
            if (!p2.pred()) {
                p2.prev().right = s2;
                s2.pred(false);
            }
            s2.right(p2.right);
            color = s2.black();
            s2.black(p2.black());
            p2.black(color);
            if (j2 == 0) {
                this.tree = s2;
            } else if (this.dirPath[j2 - 1]) {
                this.nodePath[j2 - 1].right = s2;
            } else {
                this.nodePath[j2 - 1].left = s2;
            }
        }
        int maxDepth = i2;
        if (p2.black()) {
            while (i2 > 0) {
                block70: {
                    Entry y2;
                    Entry w2;
                    if (this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].succ() || !this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].pred()) {
                        Entry x2;
                        Entry entry = x2 = this.dirPath[i2 - 1] ? this.nodePath[i2 - 1].right : this.nodePath[i2 - 1].left;
                        if (!x2.black()) {
                            x2.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i2 - 1]) {
                        w2 = this.nodePath[i2 - 1].right;
                        if (!w2.black()) {
                            w2.black(true);
                            this.nodePath[i2 - 1].black(false);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            this.nodePath[i2] = this.nodePath[i2 - 1];
                            this.dirPath[i2] = false;
                            this.nodePath[i2 - 1] = w2;
                            if (maxDepth == i2++) {
                                ++maxDepth;
                            }
                            w2 = this.nodePath[i2 - 1].right;
                        }
                        if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                            w2.black(false);
                            break block70;
                        } else {
                            if (w2.succ() || w2.right.black()) {
                                y2 = w2.left;
                                y2.black(true);
                                w2.black(false);
                                w2.left = y2.right;
                                y2.right = w2;
                                w2 = this.nodePath[i2 - 1].right = y2;
                                if (w2.succ()) {
                                    w2.succ(false);
                                    w2.right.pred(w2);
                                }
                            }
                            w2.black(this.nodePath[i2 - 1].black());
                            this.nodePath[i2 - 1].black(true);
                            w2.right.black(true);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            if (!w2.pred()) break;
                            w2.pred(false);
                            this.nodePath[i2 - 1].succ(w2);
                            break;
                        }
                    }
                    w2 = this.nodePath[i2 - 1].left;
                    if (!w2.black()) {
                        w2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        this.nodePath[i2] = this.nodePath[i2 - 1];
                        this.dirPath[i2] = true;
                        this.nodePath[i2 - 1] = w2;
                        if (maxDepth == i2++) {
                            ++maxDepth;
                        }
                        w2 = this.nodePath[i2 - 1].left;
                    }
                    if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                        w2.black(false);
                    } else {
                        if (w2.pred() || w2.left.black()) {
                            y2 = w2.right;
                            y2.black(true);
                            w2.black(false);
                            w2.right = y2.left;
                            y2.left = w2;
                            w2 = this.nodePath[i2 - 1].left = y2;
                            if (w2.pred()) {
                                w2.pred(false);
                                w2.left.succ(w2);
                            }
                        }
                        w2.black(this.nodePath[i2 - 1].black());
                        this.nodePath[i2 - 1].black(true);
                        w2.left.black(true);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        if (!w2.succ()) break;
                        w2.succ(false);
                        this.nodePath[i2 - 1].pred(w2);
                        break;
                    }
                }
                --i2;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return p2.value;
    }

    @Override
    public boolean containsValue(byte v2) {
        ValueIterator i2 = new ValueIterator();
        int j2 = this.count;
        while (j2-- != 0) {
            byte ev = i2.nextByte();
            if (ev != v2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public boolean containsKey(short k2) {
        return this.findKey(k2) != null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public byte get(short k2) {
        Entry e2 = this.findKey(k2);
        return e2 == null ? this.defRetValue : e2.value;
    }

    @Override
    public short firstShortKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public short lastShortKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectSortedSet<Short2ByteMap.Entry> short2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Short2ByteMap.Entry>(){
                final Comparator<? super Short2ByteMap.Entry> comparator = (x2, y2) -> Short2ByteRBTreeMap.this.actualComparator.compare(x2.getShortKey(), y2.getShortKey());

                @Override
                public Comparator<? super Short2ByteMap.Entry> comparator() {
                    return this.comparator;
                }

                @Override
                public ObjectBidirectionalIterator<Short2ByteMap.Entry> iterator() {
                    return new EntryIterator();
                }

                @Override
                public ObjectBidirectionalIterator<Short2ByteMap.Entry> iterator(Short2ByteMap.Entry from) {
                    return new EntryIterator(from.getShortKey());
                }

                @Override
                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Short)) {
                        return false;
                    }
                    if (e2.getValue() == null || !(e2.getValue() instanceof Byte)) {
                        return false;
                    }
                    Entry f2 = Short2ByteRBTreeMap.this.findKey((Short)e2.getKey());
                    return e2.equals(f2);
                }

                @Override
                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Short)) {
                        return false;
                    }
                    if (e2.getValue() == null || !(e2.getValue() instanceof Byte)) {
                        return false;
                    }
                    Entry f2 = Short2ByteRBTreeMap.this.findKey((Short)e2.getKey());
                    if (f2 == null || f2.getByteValue() != ((Byte)e2.getValue()).byteValue()) {
                        return false;
                    }
                    Short2ByteRBTreeMap.this.remove(f2.key);
                    return true;
                }

                @Override
                public int size() {
                    return Short2ByteRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Short2ByteRBTreeMap.this.clear();
                }

                @Override
                public Short2ByteMap.Entry first() {
                    return Short2ByteRBTreeMap.this.firstEntry;
                }

                @Override
                public Short2ByteMap.Entry last() {
                    return Short2ByteRBTreeMap.this.lastEntry;
                }

                @Override
                public ObjectSortedSet<Short2ByteMap.Entry> subSet(Short2ByteMap.Entry from, Short2ByteMap.Entry to) {
                    return Short2ByteRBTreeMap.this.subMap(from.getShortKey(), to.getShortKey()).short2ByteEntrySet();
                }

                @Override
                public ObjectSortedSet<Short2ByteMap.Entry> headSet(Short2ByteMap.Entry to) {
                    return Short2ByteRBTreeMap.this.headMap(to.getShortKey()).short2ByteEntrySet();
                }

                @Override
                public ObjectSortedSet<Short2ByteMap.Entry> tailSet(Short2ByteMap.Entry from) {
                    return Short2ByteRBTreeMap.this.tailMap(from.getShortKey()).short2ByteEntrySet();
                }
            };
        }
        return this.entries;
    }

    @Override
    public ShortSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                @Override
                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public boolean contains(byte k2) {
                    return Short2ByteRBTreeMap.this.containsValue(k2);
                }

                @Override
                public int size() {
                    return Short2ByteRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Short2ByteRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public ShortComparator comparator() {
        return this.actualComparator;
    }

    @Override
    public Short2ByteSortedMap headMap(short to) {
        return new Submap(0, true, to, false);
    }

    @Override
    public Short2ByteSortedMap tailMap(short from) {
        return new Submap(from, false, 0, true);
    }

    @Override
    public Short2ByteSortedMap subMap(short from, short to) {
        return new Submap(from, false, to, false);
    }

    public Short2ByteRBTreeMap clone() {
        Short2ByteRBTreeMap c2;
        try {
            c2 = (Short2ByteRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.allocatePaths();
        if (this.count != 0) {
            Entry rp = new Entry();
            Entry rq = new Entry();
            Entry p2 = rp;
            rp.left(this.tree);
            Entry q2 = rq;
            rq.pred(null);
            while (true) {
                Entry e2;
                if (!p2.pred()) {
                    e2 = p2.left.clone();
                    e2.pred(q2.left);
                    e2.succ(q2);
                    q2.left(e2);
                    p2 = p2.left;
                    q2 = q2.left;
                } else {
                    while (p2.succ()) {
                        p2 = p2.right;
                        if (p2 == null) {
                            q2.right = null;
                            c2.firstEntry = c2.tree = rq.left;
                            while (c2.firstEntry.left != null) {
                                c2.firstEntry = c2.firstEntry.left;
                            }
                            c2.lastEntry = c2.tree;
                            while (c2.lastEntry.right != null) {
                                c2.lastEntry = c2.lastEntry.right;
                            }
                            return c2;
                        }
                        q2 = q2.right;
                    }
                    p2 = p2.right;
                    q2 = q2.right;
                }
                if (p2.succ()) continue;
                e2 = p2.right.clone();
                e2.succ(q2.right);
                e2.pred(q2);
                q2.right(e2);
            }
        }
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int n2 = this.count;
        EntryIterator i2 = new EntryIterator();
        s2.defaultWriteObject();
        while (n2-- != 0) {
            Entry e2 = i2.nextEntry();
            s2.writeShort(e2.key);
            s2.writeByte(e2.value);
        }
    }

    private Entry readTree(ObjectInputStream s2, int n2, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n2 == 1) {
            Entry top = new Entry(s2.readShort(), s2.readByte());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n2 == 2) {
            Entry top = new Entry(s2.readShort(), s2.readByte());
            top.black(true);
            top.right(new Entry(s2.readShort(), s2.readByte()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n2 / 2;
        int leftN = n2 - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s2, leftN, pred, top));
        top.key = s2.readShort();
        top.value = s2.readByte();
        top.black(true);
        top.right(this.readTree(s2, rightN, top, succ));
        if (n2 + 2 == (n2 + 2 & -(n2 + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e2 = this.tree = this.readTree(s2, this.count, null, null);
            while (e2.left() != null) {
                e2 = e2.left();
            }
            this.firstEntry = e2;
            e2 = this.tree;
            while (e2.right() != null) {
                e2 = e2.right();
            }
            this.lastEntry = e2;
        }
    }

    private final class Submap
    extends AbstractShort2ByteSortedMap
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        short from;
        short to;
        boolean bottom;
        boolean top;
        protected transient ObjectSortedSet<Short2ByteMap.Entry> entries;
        protected transient ShortSortedSet keys;
        protected transient ByteCollection values;

        public Submap(short from, boolean bottom, short to, boolean top) {
            if (!bottom && !top && Short2ByteRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Short2ByteRBTreeMap.this.defRetValue;
        }

        @Override
        public void clear() {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                i2.nextEntry();
                i2.remove();
            }
        }

        final boolean in(short k2) {
            return !(!this.bottom && Short2ByteRBTreeMap.this.compare(k2, this.from) < 0 || !this.top && Short2ByteRBTreeMap.this.compare(k2, this.to) >= 0);
        }

        @Override
        public ObjectSortedSet<Short2ByteMap.Entry> short2ByteEntrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSortedSet<Short2ByteMap.Entry>(){

                    @Override
                    public ObjectBidirectionalIterator<Short2ByteMap.Entry> iterator() {
                        return new SubmapEntryIterator();
                    }

                    @Override
                    public ObjectBidirectionalIterator<Short2ByteMap.Entry> iterator(Short2ByteMap.Entry from) {
                        return new SubmapEntryIterator(from.getShortKey());
                    }

                    @Override
                    public Comparator<? super Short2ByteMap.Entry> comparator() {
                        return Short2ByteRBTreeMap.this.short2ByteEntrySet().comparator();
                    }

                    @Override
                    public boolean contains(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Short)) {
                            return false;
                        }
                        if (e2.getValue() == null || !(e2.getValue() instanceof Byte)) {
                            return false;
                        }
                        Entry f2 = Short2ByteRBTreeMap.this.findKey((Short)e2.getKey());
                        return f2 != null && Submap.this.in(f2.key) && e2.equals(f2);
                    }

                    @Override
                    public boolean remove(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Short)) {
                            return false;
                        }
                        if (e2.getValue() == null || !(e2.getValue() instanceof Byte)) {
                            return false;
                        }
                        Entry f2 = Short2ByteRBTreeMap.this.findKey((Short)e2.getKey());
                        if (f2 != null && Submap.this.in(f2.key)) {
                            Submap.this.remove(f2.key);
                        }
                        return f2 != null;
                    }

                    @Override
                    public int size() {
                        int c2 = 0;
                        ObjectIterator i2 = this.iterator();
                        while (i2.hasNext()) {
                            ++c2;
                            i2.next();
                        }
                        return c2;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }

                    @Override
                    public Short2ByteMap.Entry first() {
                        return Submap.this.firstEntry();
                    }

                    @Override
                    public Short2ByteMap.Entry last() {
                        return Submap.this.lastEntry();
                    }

                    @Override
                    public ObjectSortedSet<Short2ByteMap.Entry> subSet(Short2ByteMap.Entry from, Short2ByteMap.Entry to) {
                        return Submap.this.subMap(from.getShortKey(), to.getShortKey()).short2ByteEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Short2ByteMap.Entry> headSet(Short2ByteMap.Entry to) {
                        return Submap.this.headMap(to.getShortKey()).short2ByteEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Short2ByteMap.Entry> tailSet(Short2ByteMap.Entry from) {
                        return Submap.this.tailMap(from.getShortKey()).short2ByteEntrySet();
                    }
                };
            }
            return this.entries;
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public ByteCollection values() {
            if (this.values == null) {
                this.values = new AbstractByteCollection(){

                    @Override
                    public ByteIterator iterator() {
                        return new SubmapValueIterator();
                    }

                    @Override
                    public boolean contains(byte k2) {
                        return Submap.this.containsValue(k2);
                    }

                    @Override
                    public int size() {
                        return Submap.this.size();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        @Override
        public boolean containsKey(short k2) {
            return this.in(k2) && Short2ByteRBTreeMap.this.containsKey(k2);
        }

        @Override
        public boolean containsValue(byte v2) {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                byte ev = i2.nextEntry().value;
                if (ev != v2) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte get(short k2) {
            Entry e2;
            short kk = k2;
            return this.in(kk) && (e2 = Short2ByteRBTreeMap.this.findKey(kk)) != null ? e2.value : this.defRetValue;
        }

        @Override
        public byte put(short k2, byte v2) {
            Short2ByteRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                throw new IllegalArgumentException("Key (" + k2 + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            byte oldValue = Short2ByteRBTreeMap.this.put(k2, v2);
            return Short2ByteRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        @Override
        public byte remove(short k2) {
            Short2ByteRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                return this.defRetValue;
            }
            byte oldValue = Short2ByteRBTreeMap.this.remove(k2);
            return Short2ByteRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        @Override
        public int size() {
            SubmapIterator i2 = new SubmapIterator();
            int n2 = 0;
            while (i2.hasNext()) {
                ++n2;
                i2.nextEntry();
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        @Override
        public ShortComparator comparator() {
            return Short2ByteRBTreeMap.this.actualComparator;
        }

        @Override
        public Short2ByteSortedMap headMap(short to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Short2ByteRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        @Override
        public Short2ByteSortedMap tailMap(short from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Short2ByteRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        @Override
        public Short2ByteSortedMap subMap(short from, short to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                short s2 = to = Short2ByteRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                short s3 = from = Short2ByteRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e2;
            if (Short2ByteRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e2 = Short2ByteRBTreeMap.this.firstEntry;
            } else {
                e2 = Short2ByteRBTreeMap.this.locateKey(this.from);
                if (Short2ByteRBTreeMap.this.compare(e2.key, this.from) < 0) {
                    e2 = e2.next();
                }
            }
            if (e2 == null || !this.top && Short2ByteRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                return null;
            }
            return e2;
        }

        public Entry lastEntry() {
            Entry e2;
            if (Short2ByteRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e2 = Short2ByteRBTreeMap.this.lastEntry;
            } else {
                e2 = Short2ByteRBTreeMap.this.locateKey(this.to);
                if (Short2ByteRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                    e2 = e2.prev();
                }
            }
            if (e2 == null || !this.bottom && Short2ByteRBTreeMap.this.compare(e2.key, this.from) < 0) {
                return null;
            }
            return e2;
        }

        @Override
        public short firstShortKey() {
            Entry e2 = this.firstEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        @Override
        public short lastShortKey() {
            Entry e2 = this.lastEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements ByteListIterator {
            private SubmapValueIterator() {
            }

            @Override
            public byte nextByte() {
                return this.nextEntry().value;
            }

            @Override
            public byte previousByte() {
                return this.previousEntry().value;
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements ShortListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(short from) {
                super(from);
            }

            @Override
            public short nextShort() {
                return this.nextEntry().key;
            }

            @Override
            public short previousShort() {
                return this.previousEntry().key;
            }
        }

        private class SubmapEntryIterator
        extends SubmapIterator
        implements ObjectListIterator<Short2ByteMap.Entry> {
            SubmapEntryIterator() {
            }

            SubmapEntryIterator(short k2) {
                super(k2);
            }

            @Override
            public Short2ByteMap.Entry next() {
                return this.nextEntry();
            }

            @Override
            public Short2ByteMap.Entry previous() {
                return this.previousEntry();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(short k2) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Short2ByteRBTreeMap.this.compare(k2, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Short2ByteRBTreeMap.this.compare(k2, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Short2ByteRBTreeMap.this.locateKey(k2);
                if (submap.Short2ByteRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            @Override
            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Short2ByteRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            @Override
            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Short2ByteRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }

        private class KeySet
        extends AbstractShort2ByteSortedMap.KeySet {
            private KeySet() {
            }

            @Override
            public ShortBidirectionalIterator iterator() {
                return new SubmapKeyIterator();
            }

            @Override
            public ShortBidirectionalIterator iterator(short from) {
                return new SubmapKeyIterator(from);
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements ByteListIterator {
        private ValueIterator() {
        }

        @Override
        public byte nextByte() {
            return this.nextEntry().value;
        }

        @Override
        public byte previousByte() {
            return this.previousEntry().value;
        }
    }

    private class KeySet
    extends AbstractShort2ByteSortedMap.KeySet {
        private KeySet() {
        }

        @Override
        public ShortBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public ShortBidirectionalIterator iterator(short from) {
            return new KeyIterator(from);
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements ShortListIterator {
        public KeyIterator() {
        }

        public KeyIterator(short k2) {
            super(k2);
        }

        @Override
        public short nextShort() {
            return this.nextEntry().key;
        }

        @Override
        public short previousShort() {
            return this.previousEntry().key;
        }
    }

    private class EntryIterator
    extends TreeIterator
    implements ObjectListIterator<Short2ByteMap.Entry> {
        EntryIterator() {
        }

        EntryIterator(short k2) {
            super(k2);
        }

        @Override
        public Short2ByteMap.Entry next() {
            return this.nextEntry();
        }

        @Override
        public Short2ByteMap.Entry previous() {
            return this.previousEntry();
        }
    }

    private class TreeIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Short2ByteRBTreeMap.this.firstEntry;
        }

        TreeIterator(short k2) {
            this.next = Short2ByteRBTreeMap.this.locateKey(k2);
            if (this.next != null) {
                if (Short2ByteRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Short2ByteRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }

        public int back(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n2 - i2 - 1;
        }
    }

    private static final class Entry
    extends AbstractShort2ByteMap.BasicEntry
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        Entry left;
        Entry right;
        int info;

        Entry() {
            super((short)0, (byte)0);
        }

        Entry(short k2, byte v2) {
            super(k2, v2);
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        @Override
        public byte setValue(byte value) {
            byte oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Entry clone() {
            Entry c2;
            try {
                c2 = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c2.key = this.key;
            c2.value = this.value;
            c2.info = this.info;
            return c2;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key == (Short)e2.getKey() && this.value == (Byte)e2.getValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        @Override
        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

