/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractShortList
extends AbstractShortCollection
implements ShortList,
ShortStack {
    protected AbstractShortList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index, short k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(short k2) {
        this.add(this.size(), k2);
        return true;
    }

    @Override
    public short removeShort(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short set(int index, short k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Short> c2) {
        this.ensureIndex(index);
        Iterator<? extends Short> i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index++, (short)i2.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Short> c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public ShortListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ShortListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ShortListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new ShortListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractShortList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractShortList.this.getShort(this.last);
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractShortList.this.getShort(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(short k2) {
                AbstractShortList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(short k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractShortList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractShortList.this.removeShort(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(short k2) {
        return this.indexOf(k2) >= 0;
    }

    @Override
    public int indexOf(short k2) {
        ShortListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            short e2 = i2.nextShort();
            if (k2 != e2) continue;
            return i2.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short k2) {
        ShortListIterator i2 = this.listIterator(this.size());
        while (i2.hasPrevious()) {
            short e2 = i2.previousShort();
            if (k2 != e2) continue;
            return i2.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size) {
        int i2 = this.size();
        if (size > i2) {
            while (i2++ < size) {
                this.add((short)0);
            }
        } else {
            while (i2-- != size) {
                this.removeShort(i2);
            }
        }
    }

    @Override
    public ShortList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ShortSubList(this, from, to);
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        ShortListIterator i2 = this.listIterator(from);
        int n2 = to - from;
        if (n2 < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n2-- != 0) {
            i2.nextShort();
            i2.remove();
        }
    }

    @Override
    public void addElements(int index, short[] a2, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a2[offset++]);
        }
    }

    @Override
    public void addElements(int index, short[] a2) {
        this.addElements(index, a2, 0, a2.length);
    }

    @Override
    public void getElements(int from, short[] a2, int offset, int length) {
        ShortListIterator i2 = this.listIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a2[offset++] = i2.nextShort();
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    private boolean valEquals(Object a2, Object b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    @Override
    public int hashCode() {
        ShortListIterator i2 = this.iterator();
        int h2 = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            short k2 = i2.nextShort();
            h2 = 31 * h2 + k2;
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List l2 = (List)o2;
        int s2 = this.size();
        if (s2 != l2.size()) {
            return false;
        }
        if (l2 instanceof ShortList) {
            ShortListIterator i1 = this.listIterator();
            ShortListIterator i2 = ((ShortList)l2).listIterator();
            while (s2-- != 0) {
                if (i1.nextShort() == i2.nextShort()) continue;
                return false;
            }
            return true;
        }
        ShortListIterator i1 = this.listIterator();
        ListIterator i2 = l2.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Short> l2) {
        if (l2 == this) {
            return 0;
        }
        if (l2 instanceof ShortList) {
            ShortListIterator i1 = this.listIterator();
            ShortListIterator i2 = ((ShortList)l2).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                short e2;
                short e1 = i1.nextShort();
                int r2 = Short.compare(e1, e2 = i2.nextShort());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        ShortListIterator i1 = this.listIterator();
        ListIterator<? extends Short> i2 = l2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(short o2) {
        this.add(o2);
    }

    @Override
    public short popShort() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeShort(this.size() - 1);
    }

    @Override
    public short topShort() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getShort(this.size() - 1);
    }

    @Override
    public short peekShort(int i2) {
        return this.getShort(this.size() - 1 - i2);
    }

    @Override
    public boolean rem(short k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeShort(index);
        return true;
    }

    @Override
    public boolean addAll(int index, ShortCollection c2) {
        this.ensureIndex(index);
        ShortIterator i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index++, i2.nextShort());
        }
        return retVal;
    }

    @Override
    public boolean addAll(int index, ShortList l2) {
        return this.addAll(index, (ShortCollection)l2);
    }

    @Override
    public boolean addAll(ShortCollection c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public boolean addAll(ShortList l2) {
        return this.addAll(this.size(), l2);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ShortListIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("[");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            short k2 = i2.nextShort();
            s2.append(String.valueOf(k2));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class ShortSubList
    extends AbstractShortList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortList l;
        protected final int from;
        protected int to;

        public ShortSubList(ShortList l2, int from, int to) {
            this.l = l2;
            this.from = from;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(short k2) {
            this.l.add(this.to, k2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index, short k2) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public short getShort(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getShort(this.from + index);
        }

        @Override
        public short removeShort(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeShort(this.from + index);
        }

        @Override
        public short set(int index, short k2) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, short[] a2, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
            assert (this.assertRange());
        }

        @Override
        public void addElements(int index, short[] a2, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a2, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public ShortListIterator listIterator(final int index) {
            this.ensureIndex(index);
            return new ShortListIterator(){
                int pos;
                int last;
                {
                    this.pos = index;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public short nextShort() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getShort(from + this.last);
                }

                @Override
                public short previousShort() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getShort(from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(short k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k2);
                    this.last = -1;
                    assert (this.assertRange());
                }

                @Override
                public void set(short k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k2);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.removeShort(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public ShortList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new ShortSubList(this, from, to);
        }

        @Override
        public boolean rem(short k2) {
            int index = this.indexOf(k2);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeShort(this.from + index);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int index, ShortCollection c2) {
            this.ensureIndex(index);
            return super.addAll(index, c2);
        }

        @Override
        public boolean addAll(int index, ShortList l2) {
            this.ensureIndex(index);
            return super.addAll(index, l2);
        }
    }
}

