/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShort2LongFunction;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2LongMaps;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractShort2LongMap
extends AbstractShort2LongFunction
implements Short2LongMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractShort2LongMap() {
    }

    @Override
    public boolean containsValue(long v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(short k2) {
        Iterator i2 = this.short2LongEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Short2LongMap.Entry)i2.next()).getShortKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            @Override
            public boolean contains(short k2) {
                return AbstractShort2LongMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractShort2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2LongMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Short2LongMap.Entry> i;
                    {
                        this.i = Short2LongMaps.fastIterator(AbstractShort2LongMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Short2LongMap.Entry)this.i.next()).getShortKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public LongCollection values() {
        return new AbstractLongCollection(){

            @Override
            public boolean contains(long k2) {
                return AbstractShort2LongMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractShort2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2LongMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Short2LongMap.Entry> i;
                    {
                        this.i = Short2LongMaps.fastIterator(AbstractShort2LongMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Short2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Long> m2) {
        if (m2 instanceof Short2LongMap) {
            ObjectIterator<Short2LongMap.Entry> i2 = Short2LongMaps.fastIterator((Short2LongMap)m2);
            while (i2.hasNext()) {
                Short2LongMap.Entry e2 = (Short2LongMap.Entry)i2.next();
                this.put(e2.getShortKey(), e2.getLongValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Short, ? extends Long>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Short, ? extends Long> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Short2LongMap.Entry> i2 = Short2LongMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Short2LongMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.short2LongEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Short2LongMap.Entry> i2 = Short2LongMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Short2LongMap.Entry e2 = (Short2LongMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getShortKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getLongValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Short2LongMap.Entry> {
        protected final Short2LongMap map;

        public BasicEntrySet(Short2LongMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2LongMap.Entry) {
                Short2LongMap.Entry e2 = (Short2LongMap.Entry)o2;
                short k2 = e2.getShortKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getLongValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k3 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Long)value).longValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2LongMap.Entry) {
                Short2LongMap.Entry e2 = (Short2LongMap.Entry)o2;
                return this.map.remove(e2.getShortKey(), e2.getLongValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k2 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            long v2 = (Long)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Short2LongMap.Entry {
        protected short key;
        protected long value;

        public BasicEntry() {
        }

        public BasicEntry(Short key, Long value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(short key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short getShortKey() {
            return this.key;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2LongMap.Entry) {
                Short2LongMap.Entry e2 = (Short2LongMap.Entry)o2;
                return this.key == e2.getShortKey() && this.value == e2.getLongValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return this.key == (Short)key && this.value == (Long)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

