/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShort2DoubleFunction;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMap;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMaps;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractShort2DoubleMap
extends AbstractShort2DoubleFunction
implements Short2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractShort2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(short k2) {
        Iterator i2 = this.short2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Short2DoubleMap.Entry)i2.next()).getShortKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            @Override
            public boolean contains(short k2) {
                return AbstractShort2DoubleMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractShort2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2DoubleMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Short2DoubleMap.Entry> i;
                    {
                        this.i = Short2DoubleMaps.fastIterator(AbstractShort2DoubleMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Short2DoubleMap.Entry)this.i.next()).getShortKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k2) {
                return AbstractShort2DoubleMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractShort2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Short2DoubleMap.Entry> i;
                    {
                        this.i = Short2DoubleMaps.fastIterator(AbstractShort2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Short2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Double> m2) {
        if (m2 instanceof Short2DoubleMap) {
            ObjectIterator<Short2DoubleMap.Entry> i2 = Short2DoubleMaps.fastIterator((Short2DoubleMap)m2);
            while (i2.hasNext()) {
                Short2DoubleMap.Entry e2 = (Short2DoubleMap.Entry)i2.next();
                this.put(e2.getShortKey(), e2.getDoubleValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Short, ? extends Double>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Short, ? extends Double> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Short2DoubleMap.Entry> i2 = Short2DoubleMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Short2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.short2DoubleEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Short2DoubleMap.Entry> i2 = Short2DoubleMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Short2DoubleMap.Entry e2 = (Short2DoubleMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getShortKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Short2DoubleMap.Entry> {
        protected final Short2DoubleMap map;

        public BasicEntrySet(Short2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2DoubleMap.Entry) {
                Short2DoubleMap.Entry e2 = (Short2DoubleMap.Entry)o2;
                short k2 = e2.getShortKey();
                return this.map.containsKey(k2) && Double.doubleToLongBits(this.map.get(k2)) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k3 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k3) && Double.doubleToLongBits(this.map.get(k3)) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2DoubleMap.Entry) {
                Short2DoubleMap.Entry e2 = (Short2DoubleMap.Entry)o2;
                return this.map.remove(e2.getShortKey(), e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k2 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v2 = (Double)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Short2DoubleMap.Entry {
        protected short key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Short key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(short key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short getShortKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2DoubleMap.Entry) {
                Short2DoubleMap.Entry e2 = (Short2DoubleMap.Entry)o2;
                return this.key == e2.getShortKey() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.key == (Short)key && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

