/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ByteFunction;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteMaps;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractShort2ByteMap
extends AbstractShort2ByteFunction
implements Short2ByteMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractShort2ByteMap() {
    }

    @Override
    public boolean containsValue(byte v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(short k2) {
        Iterator i2 = this.short2ByteEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Short2ByteMap.Entry)i2.next()).getShortKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            @Override
            public boolean contains(short k2) {
                return AbstractShort2ByteMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractShort2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2ByteMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Short2ByteMap.Entry> i;
                    {
                        this.i = Short2ByteMaps.fastIterator(AbstractShort2ByteMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Short2ByteMap.Entry)this.i.next()).getShortKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k2) {
                return AbstractShort2ByteMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractShort2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Short2ByteMap.Entry> i;
                    {
                        this.i = Short2ByteMaps.fastIterator(AbstractShort2ByteMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Short2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Byte> m2) {
        if (m2 instanceof Short2ByteMap) {
            ObjectIterator<Short2ByteMap.Entry> i2 = Short2ByteMaps.fastIterator((Short2ByteMap)m2);
            while (i2.hasNext()) {
                Short2ByteMap.Entry e2 = (Short2ByteMap.Entry)i2.next();
                this.put(e2.getShortKey(), e2.getByteValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Short, ? extends Byte>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Short, ? extends Byte> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Short2ByteMap.Entry> i2 = Short2ByteMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Short2ByteMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.short2ByteEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Short2ByteMap.Entry> i2 = Short2ByteMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Short2ByteMap.Entry e2 = (Short2ByteMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getShortKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Short2ByteMap.Entry> {
        protected final Short2ByteMap map;

        public BasicEntrySet(Short2ByteMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2ByteMap.Entry) {
                Short2ByteMap.Entry e2 = (Short2ByteMap.Entry)o2;
                short k2 = e2.getShortKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k3 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Byte)value).byteValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2ByteMap.Entry) {
                Short2ByteMap.Entry e2 = (Short2ByteMap.Entry)o2;
                return this.map.remove(e2.getShortKey(), e2.getByteValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k2 = (Short)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            byte v2 = (Byte)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Short2ByteMap.Entry {
        protected short key;
        protected byte value;

        public BasicEntry() {
        }

        public BasicEntry(Short key, Byte value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(short key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short getShortKey() {
            return this.key;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Short2ByteMap.Entry) {
                Short2ByteMap.Entry e2 = (Short2ByteMap.Entry)o2;
                return this.key == e2.getShortKey() && this.value == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.key == (Short)key && this.value == (Byte)value;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

