/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeaps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectHeapPriorityQueue<K>
implements PriorityQueue<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient K[] heap = ObjectArrays.EMPTY_ARRAY;
    protected int size;
    protected Comparator<? super K> c;

    public ObjectHeapPriorityQueue(int capacity, Comparator<? super K> c2) {
        if (capacity > 0) {
            this.heap = new Object[capacity];
        }
        this.c = c2;
    }

    public ObjectHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ObjectHeapPriorityQueue(Comparator<? super K> c2) {
        this(0, c2);
    }

    public ObjectHeapPriorityQueue() {
        this(0, null);
    }

    public ObjectHeapPriorityQueue(K[] a2, int size, Comparator<? super K> c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        ObjectHeaps.makeHeap(a2, size, c2);
    }

    public ObjectHeapPriorityQueue(K[] a2, Comparator<? super K> c2) {
        this(a2, a2.length, c2);
    }

    public ObjectHeapPriorityQueue(K[] a2, int size) {
        this(a2, size, null);
    }

    public ObjectHeapPriorityQueue(K[] a2) {
        this(a2, a2.length);
    }

    public ObjectHeapPriorityQueue(Collection<? extends K> collection, Comparator<? super K> c2) {
        this(collection.toArray(), c2);
    }

    public ObjectHeapPriorityQueue(Collection<? extends K> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(K x2) {
        if (this.size == this.heap.length) {
            this.heap = ObjectArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        ObjectHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public K dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        K result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size != 0) {
            ObjectHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public K first() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        ObjectHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.heap, 0, this.size, null);
        this.size = 0;
    }

    public void trim() {
        this.heap = ObjectArrays.trim(this.heap, this.size);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeObject(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new Object[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readObject();
        }
    }
}

