/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;

public final class ObjectBigArrays {
    public static final Object[][] EMPTY_BIG_ARRAY = new Object[0][];
    public static final Object[][] DEFAULT_EMPTY_BIG_ARRAY = new Object[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private ObjectBigArrays() {
    }

    public static <K> K get(K[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static <K> void set(K[][] array, long index, K value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static <K> void swap(K[][] array, long first, long second) {
        K t2 = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t2;
    }

    public static <K> long length(K[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static <K> void copy(K[][] srcArray, long srcPos, K[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l2 = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l2);
                if ((srcDispl += l2) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l2) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l2;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l3 = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l3, destArray[destSegment], destDispl - l3, l3);
                srcDispl -= l3;
                destDispl -= l3;
                length -= (long)l3;
            }
        }
    }

    public static <K> void copyFromBig(K[][] srcArray, long srcPos, K[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l2 = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l2);
            if ((srcDispl += l2) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l2;
            length -= l2;
        }
    }

    public static <K> void copyToBig(K[] srcArray, int srcPos, K[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l2 = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l2);
            if ((destDispl += l2) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l2;
            length -= (long)l2;
        }
    }

    public static <K> K[][] newBigArray(K[][] prototype, long length) {
        return ObjectBigArrays.newBigArray(prototype.getClass().getComponentType(), length);
    }

    private static Object[][] newBigArray(Class<?> componentType, long length) {
        if (length == 0L && componentType == Object[].class) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Array.newInstance(componentType, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
            base[baseLength - 1] = (Object[])Array.newInstance(componentType.getComponentType(), residual);
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
        }
        return base;
    }

    public static Object[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = new Object[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new Object[0x8000000];
            }
            base[baseLength - 1] = new Object[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new Object[0x8000000];
            }
        }
        return base;
    }

    public static <K> K[][] wrap(K[] array) {
        if (array.length == 0 && array.getClass() == Object[].class) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            Object[][] bigArray = (Object[][])Array.newInstance(array.getClass(), 1);
            bigArray[0] = array;
            return bigArray;
        }
        Object[][] bigArray = ObjectBigArrays.newBigArray(array.getClass(), (long)array.length);
        for (int i2 = 0; i2 < bigArray.length; ++i2) {
            System.arraycopy(array, (int)BigArrays.start(i2), bigArray[i2], 0, bigArray[i2].length);
        }
        return bigArray;
    }

    public static <K> K[][] ensureCapacity(K[][] array, long length) {
        return ObjectBigArrays.ensureCapacity(array, length, ObjectBigArrays.length(array));
    }

    public static <K> K[][] forceCapacity(K[][] array, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array, baseLength);
        Class<?> componentType = array.getClass().getComponentType();
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = valid; i2 < baseLength - 1; ++i2) {
                base[i2] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
            base[baseLength - 1] = (Object[])Array.newInstance(componentType.getComponentType(), residual);
        } else {
            for (int i3 = valid; i3 < baseLength; ++i3) {
                base[i3] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            ObjectBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static <K> K[][] ensureCapacity(K[][] array, long length, long preserve) {
        return length > ObjectBigArrays.length(array) ? ObjectBigArrays.forceCapacity(array, length, preserve) : array;
    }

    public static <K> K[][] grow(K[][] array, long length) {
        long oldLength = ObjectBigArrays.length(array);
        return length > oldLength ? ObjectBigArrays.grow(array, length, oldLength) : array;
    }

    public static <K> K[][] grow(K[][] array, long length, long preserve) {
        long oldLength = ObjectBigArrays.length(array);
        return length > oldLength ? ObjectBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    public static <K> K[][] trim(K[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = ObjectBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ObjectArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static <K> K[][] setLength(K[][] array, long length) {
        long oldLength = ObjectBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return ObjectBigArrays.trim(array, length);
        }
        return ObjectBigArrays.ensureCapacity(array, length);
    }

    public static <K> K[][] copy(K[][] array, long offset, long length) {
        ObjectBigArrays.ensureOffsetLength(array, offset, length);
        K[][] a2 = ObjectBigArrays.newBigArray(array, length);
        ObjectBigArrays.copy(array, offset, a2, 0L, length);
        return a2;
    }

    public static <K> K[][] copy(K[][] array) {
        Object[][] base = (Object[][])array.clone();
        int i2 = base.length;
        while (i2-- != 0) {
            base[i2] = (Object[])array[i2].clone();
        }
        return base;
    }

    public static <K> void fill(K[][] array, K value) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value);
        }
    }

    public static <K> void fill(K[][] array, long from, long to, K value) {
        long length = ObjectBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array[toSegment], value);
        }
        Arrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static <K> boolean equals(K[][] a1, K[][] a2) {
        if (ObjectBigArrays.length(a1) != ObjectBigArrays.length(a2)) {
            return false;
        }
        int i2 = a1.length;
        while (i2-- != 0) {
            K[] t2 = a1[i2];
            K[] u2 = a2[i2];
            int j2 = t2.length;
            while (j2-- != 0) {
                if (Objects.equals(t2[j2], u2[j2])) continue;
                return false;
            }
        }
        return true;
    }

    public static <K> String toString(K[][] a2) {
        if (a2 == null) {
            return "null";
        }
        long last = ObjectBigArrays.length(a2) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        long i2 = 0L;
        while (true) {
            b2.append(String.valueOf(ObjectBigArrays.get(a2, i2)));
            if (i2 == last) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    public static <K> void ensureFromTo(K[][] a2, long from, long to) {
        BigArrays.ensureFromTo(ObjectBigArrays.length(a2), from, to);
    }

    public static <K> void ensureOffsetLength(K[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(ObjectBigArrays.length(a2), offset, length);
    }

    private static <K> void vecSwap(K[][] x2, long a2, long b2, long n2) {
        int i2 = 0;
        while ((long)i2 < n2) {
            ObjectBigArrays.swap(x2, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static <K> long med3(K[][] x2, long a2, long b2, long c2, Comparator<K> comp) {
        int ab2 = comp.compare(ObjectBigArrays.get(x2, a2), ObjectBigArrays.get(x2, b2));
        int ac2 = comp.compare(ObjectBigArrays.get(x2, a2), ObjectBigArrays.get(x2, c2));
        int bc = comp.compare(ObjectBigArrays.get(x2, b2), ObjectBigArrays.get(x2, c2));
        return ab2 < 0 ? (bc < 0 ? b2 : (ac2 < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac2 > 0 ? c2 : a2));
    }

    private static <K> void selectionSort(K[][] a2, long from, long to, Comparator<K> comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m2 = i2;
            for (long j2 = i2 + 1L; j2 < to; ++j2) {
                if (comp.compare(ObjectBigArrays.get(a2, j2), ObjectBigArrays.get(a2, m2)) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            ObjectBigArrays.swap(a2, i2, m2);
        }
    }

    public static <K> void quickSort(K[][] x2, long from, long to, Comparator<K> comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            ObjectBigArrays.selectionSort(x2, from, to, comp);
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l2 = ObjectBigArrays.med3(x2, l2, l2 + s2, l2 + 2L * s2, comp);
                m2 = ObjectBigArrays.med3(x2, m2 - s2, m2, m2 + s2, comp);
                n2 = ObjectBigArrays.med3(x2, n2 - 2L * s2, n2 - s2, n2, comp);
            }
            m2 = ObjectBigArrays.med3(x2, l2, m2, n2, comp);
        }
        K v2 = ObjectBigArrays.get(x2, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(ObjectBigArrays.get(x2, b2), v2)) <= 0) {
                if (comparison == 0) {
                    ObjectBigArrays.swap(x2, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(ObjectBigArrays.get(x2, c2), v2)) >= 0) {
                if (comparison == 0) {
                    ObjectBigArrays.swap(x2, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectBigArrays.swap(x2, b2++, c2--);
        }
        long n3 = to;
        long s3 = Math.min(a2 - from, b2 - a2);
        ObjectBigArrays.vecSwap(x2, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1L);
        ObjectBigArrays.vecSwap(x2, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1L) {
            ObjectBigArrays.quickSort(x2, from, from + s3, comp);
        }
        if ((s3 = d2 - c2) > 1L) {
            ObjectBigArrays.quickSort(x2, n3 - s3, n3, comp);
        }
    }

    private static <K> long med3(K[][] x2, long a2, long b2, long c2) {
        int ab2 = ((Comparable)ObjectBigArrays.get(x2, a2)).compareTo(ObjectBigArrays.get(x2, b2));
        int ac2 = ((Comparable)ObjectBigArrays.get(x2, a2)).compareTo(ObjectBigArrays.get(x2, c2));
        int bc = ((Comparable)ObjectBigArrays.get(x2, b2)).compareTo(ObjectBigArrays.get(x2, c2));
        return ab2 < 0 ? (bc < 0 ? b2 : (ac2 < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac2 > 0 ? c2 : a2));
    }

    private static <K> void selectionSort(K[][] a2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m2 = i2;
            for (long j2 = i2 + 1L; j2 < to; ++j2) {
                if (((Comparable)ObjectBigArrays.get(a2, j2)).compareTo(ObjectBigArrays.get(a2, m2)) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            ObjectBigArrays.swap(a2, i2, m2);
        }
    }

    public static <K> void quickSort(K[][] x2, Comparator<K> comp) {
        ObjectBigArrays.quickSort(x2, 0L, ObjectBigArrays.length(x2), comp);
    }

    public static <K> void quickSort(K[][] x2, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            ObjectBigArrays.selectionSort(x2, from, to);
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l2 = ObjectBigArrays.med3(x2, l2, l2 + s2, l2 + 2L * s2);
                m2 = ObjectBigArrays.med3(x2, m2 - s2, m2, m2 + s2);
                n2 = ObjectBigArrays.med3(x2, n2 - 2L * s2, n2 - s2, n2);
            }
            m2 = ObjectBigArrays.med3(x2, l2, m2, n2);
        }
        K v2 = ObjectBigArrays.get(x2, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = ((Comparable)ObjectBigArrays.get(x2, b2)).compareTo(v2)) <= 0) {
                if (comparison == 0) {
                    ObjectBigArrays.swap(x2, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = ((Comparable)ObjectBigArrays.get(x2, c2)).compareTo(v2)) >= 0) {
                if (comparison == 0) {
                    ObjectBigArrays.swap(x2, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectBigArrays.swap(x2, b2++, c2--);
        }
        long n3 = to;
        long s3 = Math.min(a2 - from, b2 - a2);
        ObjectBigArrays.vecSwap(x2, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1L);
        ObjectBigArrays.vecSwap(x2, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1L) {
            ObjectBigArrays.quickSort(x2, from, from + s3);
        }
        if ((s3 = d2 - c2) > 1L) {
            ObjectBigArrays.quickSort(x2, n3 - s3, n3);
        }
    }

    public static <K> void quickSort(K[][] x2) {
        ObjectBigArrays.quickSort(x2, 0L, ObjectBigArrays.length(x2));
    }

    public static <K> long binarySearch(K[][] a2, long from, long to, K key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            K midVal = ObjectBigArrays.get(a2, mid);
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static <K> long binarySearch(K[][] a2, Object key) {
        return ObjectBigArrays.binarySearch(a2, 0L, ObjectBigArrays.length(a2), key);
    }

    public static <K> long binarySearch(K[][] a2, long from, long to, K key, Comparator<K> c2) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            K midVal = ObjectBigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static <K> long binarySearch(K[][] a2, K key, Comparator<K> c2) {
        return ObjectBigArrays.binarySearch(a2, 0L, ObjectBigArrays.length(a2), key, c2);
    }

    public static <K> K[][] shuffle(K[][] a2, long from, long to, Random random) {
        long i2 = to - from;
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            K t2 = ObjectBigArrays.get(a2, from + i2);
            ObjectBigArrays.set(a2, from + i2, ObjectBigArrays.get(a2, from + p2));
            ObjectBigArrays.set(a2, from + p2, t2);
        }
        return a2;
    }

    public static <K> K[][] shuffle(K[][] a2, Random random) {
        long i2 = ObjectBigArrays.length(a2);
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            K t2 = ObjectBigArrays.get(a2, i2);
            ObjectBigArrays.set(a2, i2, ObjectBigArrays.get(a2, p2));
            ObjectBigArrays.set(a2, p2, t2);
        }
        return a2;
    }

    private static final class BigArrayHashStrategy<K>
    implements Hash.Strategy<K[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[][] o2) {
            return Arrays.deepHashCode(o2);
        }

        @Override
        public boolean equals(K[][] a2, K[][] b2) {
            return ObjectBigArrays.equals(a2, b2);
        }
    }
}

