/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectArrayPriorityQueue<K>
implements PriorityQueue<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient K[] array = ObjectArrays.EMPTY_ARRAY;
    protected int size;
    protected Comparator<? super K> c;
    protected transient int firstIndex;
    protected transient boolean firstIndexValid;

    public ObjectArrayPriorityQueue(int capacity, Comparator<? super K> c2) {
        if (capacity > 0) {
            this.array = new Object[capacity];
        }
        this.c = c2;
    }

    public ObjectArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ObjectArrayPriorityQueue(Comparator<? super K> c2) {
        this(0, c2);
    }

    public ObjectArrayPriorityQueue() {
        this(0, null);
    }

    public ObjectArrayPriorityQueue(K[] a2, int size, Comparator<? super K> c2) {
        this(c2);
        this.array = a2;
        this.size = size;
    }

    public ObjectArrayPriorityQueue(K[] a2, Comparator<? super K> c2) {
        this(a2, a2.length, c2);
    }

    public ObjectArrayPriorityQueue(K[] a2, int size) {
        this(a2, size, null);
    }

    public ObjectArrayPriorityQueue(K[] a2) {
        this(a2, a2.length);
    }

    private int findFirst() {
        if (this.firstIndexValid) {
            return this.firstIndex;
        }
        this.firstIndexValid = true;
        int i2 = this.size;
        int firstIndex = --i2;
        K first = this.array[firstIndex];
        if (this.c == null) {
            while (i2-- != 0) {
                if (((Comparable)this.array[i2]).compareTo(first) >= 0) continue;
                firstIndex = i2;
                first = this.array[firstIndex];
            }
        } else {
            while (i2-- != 0) {
                if (this.c.compare(this.array[i2], first) >= 0) continue;
                firstIndex = i2;
                first = this.array[firstIndex];
            }
        }
        this.firstIndex = firstIndex;
        return this.firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(K x2) {
        if (this.size == this.array.length) {
            this.array = ObjectArrays.grow(this.array, this.size + 1);
        }
        if (this.firstIndexValid) {
            if (this.c == null) {
                if (((Comparable)x2).compareTo(this.array[this.firstIndex]) < 0) {
                    this.firstIndex = this.size;
                }
            } else if (this.c.compare(x2, this.array[this.firstIndex]) < 0) {
                this.firstIndex = this.size;
            }
        } else {
            this.firstIndexValid = false;
        }
        this.array[this.size++] = x2;
    }

    @Override
    public K dequeue() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        K result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        this.array[this.size] = null;
        this.firstIndexValid = false;
        return result;
    }

    @Override
    public K first() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
        this.firstIndexValid = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, 0, this.size, null);
        this.size = 0;
        this.firstIndexValid = false;
    }

    public void trim() {
        this.array = ObjectArrays.trim(this.array, this.size);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.array.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeObject(this.array[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.array = new Object[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.array[i2] = s2.readObject();
        }
    }
}

