/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ShortFunction;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ShortMap;
import it.unimi.dsi.fastutil.objects.Reference2ShortMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractReference2ShortMap<K>
extends AbstractReference2ShortFunction<K>
implements Reference2ShortMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractReference2ShortMap() {
    }

    @Override
    public boolean containsValue(short v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(Object k2) {
        Iterator i2 = this.reference2ShortEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Reference2ShortMap.Entry)i2.next()).getKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractReference2ShortMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractReference2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2ShortMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Reference2ShortMap.Entry<K>> i;
                    {
                        this.i = Reference2ShortMaps.fastIterator(AbstractReference2ShortMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Reference2ShortMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k2) {
                return AbstractReference2ShortMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractReference2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Reference2ShortMap.Entry<K>> i;
                    {
                        this.i = Reference2ShortMaps.fastIterator(AbstractReference2ShortMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Reference2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Short> m2) {
        if (m2 instanceof Reference2ShortMap) {
            ObjectIterator i2 = Reference2ShortMaps.fastIterator((Reference2ShortMap)m2);
            while (i2.hasNext()) {
                Reference2ShortMap.Entry e2 = (Reference2ShortMap.Entry)i2.next();
                this.put(e2.getKey(), e2.getShortValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<K, Short>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<K, Short> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Reference2ShortMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Reference2ShortMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.reference2ShortEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Reference2ShortMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Reference2ShortMap.Entry e2 = (Reference2ShortMap.Entry)i2.next();
            if (this == e2.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e2.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e2.getShortValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Reference2ShortMap.Entry<K>> {
        protected final Reference2ShortMap<K> map;

        public BasicEntrySet(Reference2ShortMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2ShortMap.Entry) {
                Reference2ShortMap.Entry e2 = (Reference2ShortMap.Entry)o2;
                Object k2 = e2.getKey();
                return this.map.containsKey(k2) && this.map.getShort(k2) == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k3 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.getShort(k3) == ((Short)value).shortValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2ShortMap.Entry) {
                Reference2ShortMap.Entry e2 = (Reference2ShortMap.Entry)o2;
                return this.map.remove(e2.getKey(), e2.getShortValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k2 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            short v2 = (Short)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Reference2ShortMap.Entry<K> {
        protected K key;
        protected short value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2ShortMap.Entry) {
                Reference2ShortMap.Entry e2 = (Reference2ShortMap.Entry)o2;
                return this.key == e2.getKey() && this.value == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.key == key && this.value == (Short)value;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

