/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2IntFunction;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractReference2IntMap<K>
extends AbstractReference2IntFunction<K>
implements Reference2IntMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractReference2IntMap() {
    }

    @Override
    public boolean containsValue(int v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(Object k2) {
        Iterator i2 = this.reference2IntEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Reference2IntMap.Entry)i2.next()).getKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractReference2IntMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractReference2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2IntMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Reference2IntMap.Entry<K>> i;
                    {
                        this.i = Reference2IntMaps.fastIterator(AbstractReference2IntMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Reference2IntMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k2) {
                return AbstractReference2IntMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractReference2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Reference2IntMap.Entry<K>> i;
                    {
                        this.i = Reference2IntMaps.fastIterator(AbstractReference2IntMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Reference2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> m2) {
        if (m2 instanceof Reference2IntMap) {
            ObjectIterator i2 = Reference2IntMaps.fastIterator((Reference2IntMap)m2);
            while (i2.hasNext()) {
                Reference2IntMap.Entry e2 = (Reference2IntMap.Entry)i2.next();
                this.put(e2.getKey(), e2.getIntValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<K, Integer>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<K, Integer> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Reference2IntMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Reference2IntMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.reference2IntEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Reference2IntMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Reference2IntMap.Entry e2 = (Reference2IntMap.Entry)i2.next();
            if (this == e2.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e2.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e2.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Reference2IntMap.Entry<K>> {
        protected final Reference2IntMap<K> map;

        public BasicEntrySet(Reference2IntMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2IntMap.Entry) {
                Reference2IntMap.Entry e2 = (Reference2IntMap.Entry)o2;
                Object k2 = e2.getKey();
                return this.map.containsKey(k2) && this.map.getInt(k2) == e2.getIntValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k3 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.getInt(k3) == ((Integer)value).intValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2IntMap.Entry) {
                Reference2IntMap.Entry e2 = (Reference2IntMap.Entry)o2;
                return this.map.remove(e2.getKey(), e2.getIntValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k2 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            int v2 = (Integer)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Reference2IntMap.Entry<K> {
        protected K key;
        protected int value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Integer value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2IntMap.Entry) {
                Reference2IntMap.Entry e2 = (Reference2IntMap.Entry)o2;
                return this.key == e2.getKey() && this.value == e2.getIntValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.key == key && this.value == (Integer)value;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

