/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2FloatFunction;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractReference2FloatMap<K>
extends AbstractReference2FloatFunction<K>
implements Reference2FloatMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractReference2FloatMap() {
    }

    @Override
    public boolean containsValue(float v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(Object k2) {
        Iterator i2 = this.reference2FloatEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Reference2FloatMap.Entry)i2.next()).getKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractReference2FloatMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractReference2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2FloatMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Reference2FloatMap.Entry<K>> i;
                    {
                        this.i = Reference2FloatMaps.fastIterator(AbstractReference2FloatMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Reference2FloatMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            @Override
            public boolean contains(float k2) {
                return AbstractReference2FloatMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractReference2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2FloatMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Reference2FloatMap.Entry<K>> i;
                    {
                        this.i = Reference2FloatMaps.fastIterator(AbstractReference2FloatMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Reference2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Float> m2) {
        if (m2 instanceof Reference2FloatMap) {
            ObjectIterator i2 = Reference2FloatMaps.fastIterator((Reference2FloatMap)m2);
            while (i2.hasNext()) {
                Reference2FloatMap.Entry e2 = (Reference2FloatMap.Entry)i2.next();
                this.put(e2.getKey(), e2.getFloatValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<K, Float>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<K, Float> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Reference2FloatMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Reference2FloatMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.reference2FloatEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Reference2FloatMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Reference2FloatMap.Entry e2 = (Reference2FloatMap.Entry)i2.next();
            if (this == e2.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e2.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e2.getFloatValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Reference2FloatMap.Entry<K>> {
        protected final Reference2FloatMap<K> map;

        public BasicEntrySet(Reference2FloatMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2FloatMap.Entry) {
                Reference2FloatMap.Entry e2 = (Reference2FloatMap.Entry)o2;
                Object k2 = e2.getKey();
                return this.map.containsKey(k2) && Float.floatToIntBits(this.map.getFloat(k2)) == Float.floatToIntBits(e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k3 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.map.containsKey(k3) && Float.floatToIntBits(this.map.getFloat(k3)) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2FloatMap.Entry) {
                Reference2FloatMap.Entry e2 = (Reference2FloatMap.Entry)o2;
                return this.map.remove(e2.getKey(), e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k2 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            float v2 = ((Float)value).floatValue();
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Reference2FloatMap.Entry<K> {
        protected K key;
        protected float value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Float value) {
            this.key = key;
            this.value = value.floatValue();
        }

        public BasicEntry(K key, float value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Reference2FloatMap.Entry) {
                Reference2FloatMap.Entry e2 = (Reference2FloatMap.Entry)o2;
                return this.key == e2.getKey() && Float.floatToIntBits(this.value) == Float.floatToIntBits(e2.getFloatValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.key == key && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

