/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2DoubleFunction;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractObject2DoubleMap<K>
extends AbstractObject2DoubleFunction<K>
implements Object2DoubleMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(Object k2) {
        Iterator i2 = this.object2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Object2DoubleMap.Entry)i2.next()).getKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractObject2DoubleMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractObject2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2DoubleMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2DoubleMap.Entry<K>> i;
                    {
                        this.i = Object2DoubleMaps.fastIterator(AbstractObject2DoubleMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2DoubleMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k2) {
                return AbstractObject2DoubleMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractObject2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Object2DoubleMap.Entry<K>> i;
                    {
                        this.i = Object2DoubleMaps.fastIterator(AbstractObject2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Object2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Double> m2) {
        if (m2 instanceof Object2DoubleMap) {
            ObjectIterator i2 = Object2DoubleMaps.fastIterator((Object2DoubleMap)m2);
            while (i2.hasNext()) {
                Object2DoubleMap.Entry e2 = (Object2DoubleMap.Entry)i2.next();
                this.put(e2.getKey(), e2.getDoubleValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<K, Double>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<K, Double> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Object2DoubleMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Object2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.object2DoubleEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Object2DoubleMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2DoubleMap.Entry e2 = (Object2DoubleMap.Entry)i2.next();
            if (this == e2.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e2.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e2.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Object2DoubleMap.Entry<K>> {
        protected final Object2DoubleMap<K> map;

        public BasicEntrySet(Object2DoubleMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2DoubleMap.Entry) {
                Object2DoubleMap.Entry e2 = (Object2DoubleMap.Entry)o2;
                Object k2 = e2.getKey();
                return this.map.containsKey(k2) && Double.doubleToLongBits(this.map.getDouble(k2)) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k3 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k3) && Double.doubleToLongBits(this.map.getDouble(k3)) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2DoubleMap.Entry) {
                Object2DoubleMap.Entry e2 = (Object2DoubleMap.Entry)o2;
                return this.map.remove(e2.getKey(), e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k2 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v2 = (Double)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Object2DoubleMap.Entry<K> {
        protected K key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2DoubleMap.Entry) {
                Object2DoubleMap.Entry e2 = (Object2DoubleMap.Entry)o2;
                return Objects.equals(this.key, e2.getKey()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return Objects.equals(this.key, key) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

