/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2ByteFunction;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractObject2ByteMap<K>
extends AbstractObject2ByteFunction<K>
implements Object2ByteMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2ByteMap() {
    }

    @Override
    public boolean containsValue(byte v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(Object k2) {
        Iterator i2 = this.object2ByteEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Object2ByteMap.Entry)i2.next()).getKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k2) {
                return AbstractObject2ByteMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractObject2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ByteMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2ByteMap.Entry<K>> i;
                    {
                        this.i = Object2ByteMaps.fastIterator(AbstractObject2ByteMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2ByteMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k2) {
                return AbstractObject2ByteMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractObject2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Object2ByteMap.Entry<K>> i;
                    {
                        this.i = Object2ByteMaps.fastIterator(AbstractObject2ByteMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Object2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Byte> m2) {
        if (m2 instanceof Object2ByteMap) {
            ObjectIterator i2 = Object2ByteMaps.fastIterator((Object2ByteMap)m2);
            while (i2.hasNext()) {
                Object2ByteMap.Entry e2 = (Object2ByteMap.Entry)i2.next();
                this.put(e2.getKey(), e2.getByteValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<K, Byte>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<K, Byte> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator i2 = Object2ByteMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Object2ByteMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.object2ByteEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = Object2ByteMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2ByteMap.Entry e2 = (Object2ByteMap.Entry)i2.next();
            if (this == e2.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e2.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e2.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Object2ByteMap.Entry<K>> {
        protected final Object2ByteMap<K> map;

        public BasicEntrySet(Object2ByteMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2ByteMap.Entry) {
                Object2ByteMap.Entry e2 = (Object2ByteMap.Entry)o2;
                Object k2 = e2.getKey();
                return this.map.containsKey(k2) && this.map.getByte(k2) == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k3 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.getByte(k3) == ((Byte)value).byteValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2ByteMap.Entry) {
                Object2ByteMap.Entry e2 = (Object2ByteMap.Entry)o2;
                return this.map.remove(e2.getKey(), e2.getByteValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object k2 = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            byte v2 = (Byte)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Object2ByteMap.Entry<K> {
        protected K key;
        protected byte value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Byte value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Object2ByteMap.Entry) {
                Object2ByteMap.Entry e2 = (Object2ByteMap.Entry)o2;
                return Objects.equals(this.key, e2.getKey()) && this.value == e2.getByteValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            Object value = e3.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return Objects.equals(this.key, key) && this.value == (Byte)value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

