/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongPredicate;

public final class LongIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private LongIterators() {
    }

    public static LongListIterator singleton(long element) {
        return new SingletonIterator(element);
    }

    public static LongListIterator wrap(long[] array, int offset, int length) {
        LongArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static LongListIterator wrap(long[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(LongIterator i2, long[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            array[offset++] = i2.nextLong();
        }
        return max - j2 - 1;
    }

    public static int unwrap(LongIterator i2, long[] array) {
        return LongIterators.unwrap(i2, array, 0, array.length);
    }

    public static long[] unwrap(LongIterator i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        long[] array = new long[16];
        int j2 = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j2 == array.length) {
                array = LongArrays.grow(array, j2 + 1);
            }
            array[j2++] = i2.nextLong();
        }
        return LongArrays.trim(array, j2);
    }

    public static long[] unwrap(LongIterator i2) {
        return LongIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static int unwrap(LongIterator i2, LongCollection c2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            c2.add(i2.nextLong());
        }
        return max - j2 - 1;
    }

    public static long unwrap(LongIterator i2, LongCollection c2) {
        long n2 = 0L;
        while (i2.hasNext()) {
            c2.add(i2.nextLong());
            ++n2;
        }
        return n2;
    }

    public static int pour(LongIterator i2, LongCollection s2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            s2.add(i2.nextLong());
        }
        return max - j2 - 1;
    }

    public static int pour(LongIterator i2, LongCollection s2) {
        return LongIterators.pour(i2, s2, Integer.MAX_VALUE);
    }

    public static LongList pour(LongIterator i2, int max) {
        LongArrayList l2 = new LongArrayList();
        LongIterators.pour(i2, l2, max);
        l2.trim();
        return l2;
    }

    public static LongList pour(LongIterator i2) {
        return LongIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static LongIterator asLongIterator(Iterator i2) {
        if (i2 instanceof LongIterator) {
            return (LongIterator)i2;
        }
        return new IteratorWrapper(i2);
    }

    public static LongListIterator asLongIterator(ListIterator i2) {
        if (i2 instanceof LongListIterator) {
            return (LongListIterator)i2;
        }
        return new ListIteratorWrapper(i2);
    }

    public static boolean any(LongIterator iterator, LongPredicate predicate) {
        return LongIterators.indexOf(iterator, predicate) != -1;
    }

    public static boolean all(LongIterator iterator, LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (predicate.test(iterator.nextLong()));
        return false;
    }

    public static int indexOf(LongIterator iterator, LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        int i2 = 0;
        while (iterator.hasNext()) {
            if (predicate.test(iterator.nextLong())) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static LongBidirectionalIterator fromTo(long from, long to) {
        return new IntervalIterator(from, to);
    }

    public static LongIterator concat(LongIterator[] a2) {
        return LongIterators.concat(a2, 0, a2.length);
    }

    public static LongIterator concat(LongIterator[] a2, int offset, int length) {
        return new IteratorConcatenator(a2, offset, length);
    }

    public static LongIterator unmodifiable(LongIterator i2) {
        return new UnmodifiableIterator(i2);
    }

    public static LongBidirectionalIterator unmodifiable(LongBidirectionalIterator i2) {
        return new UnmodifiableBidirectionalIterator(i2);
    }

    public static LongListIterator unmodifiable(LongListIterator i2) {
        return new UnmodifiableListIterator(i2);
    }

    public static LongIterator wrap(ByteIterator iterator) {
        return new ByteIteratorWrapper(iterator);
    }

    public static LongIterator wrap(ShortIterator iterator) {
        return new ShortIteratorWrapper(iterator);
    }

    public static LongIterator wrap(IntIterator iterator) {
        return new IntIteratorWrapper(iterator);
    }

    protected static class IntIteratorWrapper
    implements LongIterator {
        final IntIterator iterator;

        public IntIteratorWrapper(IntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Long next() {
            return this.iterator.nextInt();
        }

        @Override
        public long nextLong() {
            return this.iterator.nextInt();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class ShortIteratorWrapper
    implements LongIterator {
        final ShortIterator iterator;

        public ShortIteratorWrapper(ShortIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Long next() {
            return this.iterator.nextShort();
        }

        @Override
        public long nextLong() {
            return this.iterator.nextShort();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class ByteIteratorWrapper
    implements LongIterator {
        final ByteIterator iterator;

        public ByteIteratorWrapper(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Long next() {
            return this.iterator.nextByte();
        }

        @Override
        public long nextLong() {
            return this.iterator.nextByte();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    public static class UnmodifiableListIterator
    implements LongListIterator {
        protected final LongListIterator i;

        public UnmodifiableListIterator(LongListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public long nextLong() {
            return this.i.nextLong();
        }

        @Override
        public long previousLong() {
            return this.i.previousLong();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    implements LongBidirectionalIterator {
        protected final LongBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(LongBidirectionalIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public long nextLong() {
            return this.i.nextLong();
        }

        @Override
        public long previousLong() {
            return this.i.previousLong();
        }
    }

    public static class UnmodifiableIterator
    implements LongIterator {
        protected final LongIterator i;

        public UnmodifiableIterator(LongIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public long nextLong() {
            return this.i.nextLong();
        }
    }

    private static class IteratorConcatenator
    implements LongIterator {
        final LongIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(LongIterator[] a2, int offset, int length) {
            this.a = a2;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            long next = this.a[this.lastOffset].nextLong();
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n2) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n2 && this.length != 0) {
                skipped += this.a[this.offset].skip(n2 - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class IntervalIterator
    implements LongBidirectionalIterator {
        private final long from;
        private final long to;
        long curr;

        public IntervalIterator(long from, long to) {
            this.from = this.curr = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.to;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > this.from;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.curr++;
        }

        @Override
        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return --this.curr;
        }

        @Override
        public int skip(int n2) {
            if (this.curr + (long)n2 <= this.to) {
                this.curr += (long)n2;
                return n2;
            }
            n2 = (int)(this.to - this.curr);
            this.curr = this.to;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (this.curr - (long)n2 >= this.from) {
                this.curr -= (long)n2;
                return n2;
            }
            n2 = (int)(this.curr - this.from);
            this.curr = this.from;
            return n2;
        }
    }

    private static class ListIteratorWrapper
    implements LongListIterator {
        final ListIterator<Long> i;

        public ListIteratorWrapper(ListIterator<Long> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(long k2) {
            this.i.set(k2);
        }

        @Override
        public void add(long k2) {
            this.i.add(k2);
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public long nextLong() {
            return this.i.next();
        }

        @Override
        public long previousLong() {
            return this.i.previous();
        }
    }

    private static class IteratorWrapper
    implements LongIterator {
        final Iterator<Long> i;

        public IteratorWrapper(Iterator<Long> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public long nextLong() {
            return this.i.next();
        }
    }

    private static class ArrayIterator
    implements LongListIterator {
        private final long[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(long[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public int skip(int n2) {
            if (n2 <= this.length - this.curr) {
                this.curr += n2;
                return n2;
            }
            n2 = this.length - this.curr;
            this.curr = this.length;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (n2 <= this.curr) {
                this.curr -= n2;
                return n2;
            }
            n2 = this.curr;
            this.curr = 0;
            return n2;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class SingletonIterator
    implements LongListIterator {
        private final long element;
        private int curr;

        public SingletonIterator(long element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyIterator
    implements LongListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public long previousLong() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n2) {
            return 0;
        }

        @Override
        public int back(int n2) {
            return 0;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }
}

