/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongBigListIterators;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongCollections;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public final class LongBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private LongBigLists() {
    }

    public static LongBigList shuffle(LongBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            long t2 = l2.getLong(i2);
            l2.set(i2, l2.getLong(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static LongBigList singleton(long element) {
        return new Singleton(element);
    }

    public static LongBigList singleton(Object element) {
        return new Singleton((Long)element);
    }

    public static LongBigList synchronize(LongBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static LongBigList synchronize(LongBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static LongBigList unmodifiable(LongBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static LongBigList asBigList(LongList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractLongBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final LongList list;

        protected ListBigList(LongList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public LongBigListIterator iterator() {
            return LongBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public LongBigListIterator listIterator() {
            return LongBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public LongBigListIterator listIterator(long index) {
            return LongBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Long> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public LongBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(long key) {
            return this.list.contains(key);
        }

        @Override
        public long[] toLongArray() {
            return this.list.toLongArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public long[] toLongArray(long[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, LongCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(LongCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, LongBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(LongBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(LongCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(LongCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(LongCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, long key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(long key) {
            return this.list.add(key);
        }

        @Override
        public long getLong(long index) {
            return this.list.getLong(this.intIndex(index));
        }

        @Override
        public long indexOf(long k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(long k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public long removeLong(long index) {
            return this.list.removeLong(this.intIndex(index));
        }

        @Override
        public long set(long index, long k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends LongCollections.UnmodifiableCollection
    implements LongBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongBigList list;

        protected UnmodifiableBigList(LongBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public long getLong(long i2) {
            return this.list.getLong(i2);
        }

        @Override
        public long set(long i2, long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long removeLong(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(long k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(long k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Long> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, long[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, long[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, long[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public LongBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public LongBigListIterator listIterator() {
            return LongBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public LongBigListIterator listIterator(long i2) {
            return LongBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public LongBigList subList(long from, long to) {
            return LongBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Long> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(LongBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, LongBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long set(long index, Long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends LongCollections.SynchronizedCollection
    implements LongBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongBigList list;

        protected SynchronizedBigList(LongBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(LongBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getLong(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long set(long i2, long k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, long k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long removeLong(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeLong(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(long k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(long k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Long> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, long[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, long[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, long[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public LongBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public LongBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public LongBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LongBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return LongBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Long> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, LongCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, LongBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(LongBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Long k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Long get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Long set(long index, Long k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Long remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractLongBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final long element;

        protected Singleton(long element) {
            this.element = element;
        }

        @Override
        public long getLong(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long removeLong(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(long k2) {
            return k2 == this.element;
        }

        @Override
        public long[] toLongArray() {
            long[] a2 = new long[]{this.element};
            return a2;
        }

        @Override
        public LongBigListIterator listIterator() {
            return LongBigListIterators.singleton(this.element);
        }

        @Override
        public LongBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            LongBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextLong();
            }
            return l2;
        }

        @Override
        public LongBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Long> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Long> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(LongBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, LongBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends LongCollections.EmptyCollection
    implements LongBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public long getLong(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long removeLong(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long set(long index, long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(long k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(long k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Long> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(LongBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, LongCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, LongBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Long set(long index, Long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public LongBigListIterator listIterator() {
            return LongBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public LongBigListIterator iterator() {
            return LongBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public LongBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return LongBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public LongBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, long[][] a2, long offset, long length) {
            LongBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, long[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, long[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Long> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

