/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class LongBigArrayBigList
extends AbstractLongBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient long[][] a;
    protected long size;

    protected LongBigArrayBigList(long[][] a2, boolean dummy) {
        this.a = a2;
    }

    public LongBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0L ? LongBigArrays.EMPTY_BIG_ARRAY : LongBigArrays.newBigArray(capacity);
    }

    public LongBigArrayBigList() {
        this.a = LongBigArrays.DEFAULT_EMPTY_BIG_ARRAY;
    }

    public LongBigArrayBigList(LongCollection c2) {
        this(c2.size());
        LongIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextLong());
        }
    }

    public LongBigArrayBigList(LongBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public LongBigArrayBigList(long[][] a2) {
        this(a2, 0L, LongBigArrays.length(a2));
    }

    public LongBigArrayBigList(long[][] a2, long offset, long length) {
        this(length);
        LongBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public LongBigArrayBigList(Iterator<? extends Long> i2) {
        this();
        while (i2.hasNext()) {
            this.add((long)i2.next());
        }
    }

    public LongBigArrayBigList(LongIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextLong());
        }
    }

    public long[][] elements() {
        return this.a;
    }

    public static LongBigArrayBigList wrap(long[][] a2, long length) {
        if (length > LongBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + LongBigArrays.length(a2) + ")");
        }
        LongBigArrayBigList l2 = new LongBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static LongBigArrayBigList wrap(long[][] a2) {
        return LongBigArrayBigList.wrap(a2, LongBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        if (capacity <= (long)this.a.length || this.a == LongBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            return;
        }
        this.a = LongBigArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= LongBigArrays.length(this.a));
    }

    private void grow(long capacity) {
        long oldLength = LongBigArrays.length(this.a);
        if (capacity <= oldLength) {
            return;
        }
        if (this.a != LongBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            capacity = Math.max(oldLength + (oldLength >> 1), capacity);
        } else if (capacity < 10L) {
            capacity = 10L;
        }
        this.a = LongBigArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= LongBigArrays.length(this.a));
    }

    @Override
    public void add(long index, long k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            LongBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        LongBigArrays.set(this.a, index, k2);
        ++this.size;
        assert (this.size <= LongBigArrays.length(this.a));
    }

    @Override
    public boolean add(long k2) {
        this.grow(this.size + 1L);
        LongBigArrays.set(this.a, this.size++, k2);
        assert (this.size <= LongBigArrays.length(this.a));
        return true;
    }

    @Override
    public long getLong(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return LongBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(long k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (k2 != LongBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(long k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (k2 != LongBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long removeLong(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = LongBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            LongBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        assert (this.size <= LongBigArrays.length(this.a));
        return old;
    }

    @Override
    public boolean rem(long k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeLong(index);
        assert (this.size <= LongBigArrays.length(this.a));
        return true;
    }

    @Override
    public long set(long index, long k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = LongBigArrays.get(this.a, index);
        LongBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(LongCollection c2) {
        long[] s2 = null;
        long[] d2 = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c2.contains((long)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        long[] s2 = null;
        long[] d2 = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c2.contains((long)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
        assert (this.size <= LongBigArrays.length(this.a));
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > LongBigArrays.length(this.a)) {
            this.a = LongBigArrays.forceCapacity(this.a, size, this.size);
        }
        if (size > this.size) {
            LongBigArrays.fill(this.a, this.size, size, 0L);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = LongBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = LongBigArrays.trim(this.a, Math.max(n2, this.size));
        assert (this.size <= LongBigArrays.length(this.a));
    }

    @Override
    public void getElements(long from, long[][] a2, long offset, long length) {
        LongBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        LongBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, long[][] a2, long offset, long length) {
        this.ensureIndex(index);
        LongBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        LongBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        LongBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public LongBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new LongBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < LongBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return LongBigArrays.get(LongBigArrayBigList.this.a, this.last);
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return LongBigArrays.get(LongBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(long k2) {
                LongBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(long k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongBigArrayBigList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public LongBigArrayBigList clone() {
        LongBigArrayBigList c2 = new LongBigArrayBigList(this.size);
        LongBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(LongBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        long[][] a1 = this.a;
        long[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (LongBigArrays.get(a1, s2) == LongBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(LongBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        long[][] a1 = this.a;
        long[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            long e2;
            long e1 = LongBigArrays.get(a1, i2);
            int r2 = Long.compare(e1, e2 = LongBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeLong(LongBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = LongBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            LongBigArrays.set(this.a, i2, s2.readLong());
            ++i2;
        }
    }
}

