/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class LongArrayPriorityQueue
implements LongPriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient long[] array = LongArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;
    protected transient int firstIndex;
    protected transient boolean firstIndexValid;

    public LongArrayPriorityQueue(int capacity, LongComparator c2) {
        if (capacity > 0) {
            this.array = new long[capacity];
        }
        this.c = c2;
    }

    public LongArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public LongArrayPriorityQueue(LongComparator c2) {
        this(0, c2);
    }

    public LongArrayPriorityQueue() {
        this(0, null);
    }

    public LongArrayPriorityQueue(long[] a2, int size, LongComparator c2) {
        this(c2);
        this.array = a2;
        this.size = size;
    }

    public LongArrayPriorityQueue(long[] a2, LongComparator c2) {
        this(a2, a2.length, c2);
    }

    public LongArrayPriorityQueue(long[] a2, int size) {
        this(a2, size, null);
    }

    public LongArrayPriorityQueue(long[] a2) {
        this(a2, a2.length);
    }

    private int findFirst() {
        if (this.firstIndexValid) {
            return this.firstIndex;
        }
        this.firstIndexValid = true;
        int i2 = this.size;
        int firstIndex = --i2;
        long first = this.array[firstIndex];
        if (this.c == null) {
            while (i2-- != 0) {
                if (this.array[i2] >= first) continue;
                firstIndex = i2;
                first = this.array[firstIndex];
            }
        } else {
            while (i2-- != 0) {
                if (this.c.compare(this.array[i2], first) >= 0) continue;
                firstIndex = i2;
                first = this.array[firstIndex];
            }
        }
        this.firstIndex = firstIndex;
        return this.firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(long x2) {
        if (this.size == this.array.length) {
            this.array = LongArrays.grow(this.array, this.size + 1);
        }
        if (this.firstIndexValid) {
            if (this.c == null) {
                if (x2 < this.array[this.firstIndex]) {
                    this.firstIndex = this.size;
                }
            } else if (this.c.compare(x2, this.array[this.firstIndex]) < 0) {
                this.firstIndex = this.size;
            }
        } else {
            this.firstIndexValid = false;
        }
        this.array[this.size++] = x2;
    }

    @Override
    public long dequeueLong() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        long result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        this.firstIndexValid = false;
        return result;
    }

    @Override
    public long firstLong() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
        this.firstIndexValid = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.firstIndexValid = false;
    }

    public void trim() {
        this.array = LongArrays.trim(this.array, this.size);
    }

    @Override
    public LongComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.array.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeLong(this.array[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.array = new long[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.array[i2] = s2.readLong();
        }
    }
}

