/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLong2ShortFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ShortMap;
import it.unimi.dsi.fastutil.longs.Long2ShortMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLong2ShortMap
extends AbstractLong2ShortFunction
implements Long2ShortMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2ShortMap() {
    }

    @Override
    public boolean containsValue(short v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(long k2) {
        Iterator i2 = this.long2ShortEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Long2ShortMap.Entry)i2.next()).getLongKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k2) {
                return AbstractLong2ShortMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ShortMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2ShortMap.Entry> i;
                    {
                        this.i = Long2ShortMaps.fastIterator(AbstractLong2ShortMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2ShortMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k2) {
                return AbstractLong2ShortMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Long2ShortMap.Entry> i;
                    {
                        this.i = Long2ShortMaps.fastIterator(AbstractLong2ShortMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Long2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Short> m2) {
        if (m2 instanceof Long2ShortMap) {
            ObjectIterator<Long2ShortMap.Entry> i2 = Long2ShortMaps.fastIterator((Long2ShortMap)m2);
            while (i2.hasNext()) {
                Long2ShortMap.Entry e2 = (Long2ShortMap.Entry)i2.next();
                this.put(e2.getLongKey(), e2.getShortValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Long, ? extends Short>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Long, ? extends Short> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Long2ShortMap.Entry> i2 = Long2ShortMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Long2ShortMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.long2ShortEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Long2ShortMap.Entry> i2 = Long2ShortMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Long2ShortMap.Entry e2 = (Long2ShortMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getLongKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getShortValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Long2ShortMap.Entry> {
        protected final Long2ShortMap map;

        public BasicEntrySet(Long2ShortMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ShortMap.Entry) {
                Long2ShortMap.Entry e2 = (Long2ShortMap.Entry)o2;
                long k2 = e2.getLongKey();
                return this.map.containsKey(k2) && this.map.get(k2) == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k3 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.map.containsKey(k3) && this.map.get(k3) == ((Short)value).shortValue();
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ShortMap.Entry) {
                Long2ShortMap.Entry e2 = (Long2ShortMap.Entry)o2;
                return this.map.remove(e2.getLongKey(), e2.getShortValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k2 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            short v2 = (Short)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Long2ShortMap.Entry {
        protected long key;
        protected short value;

        public BasicEntry() {
        }

        public BasicEntry(Long key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2ShortMap.Entry) {
                Long2ShortMap.Entry e2 = (Long2ShortMap.Entry)o2;
                return this.key == e2.getLongKey() && this.value == e2.getShortValue();
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Short)) {
                return false;
            }
            return this.key == (Long)key && this.value == (Short)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

