/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2DoubleFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLong2DoubleMap
extends AbstractLong2DoubleFunction
implements Long2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v2) {
        return this.values().contains(v2);
    }

    @Override
    public boolean containsKey(long k2) {
        Iterator i2 = this.long2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Long2DoubleMap.Entry)i2.next()).getLongKey() != k2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k2) {
                return AbstractLong2DoubleMap.this.containsKey(k2);
            }

            @Override
            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2DoubleMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2DoubleMap.Entry> i;
                    {
                        this.i = Long2DoubleMaps.fastIterator(AbstractLong2DoubleMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k2) {
                return AbstractLong2DoubleMap.this.containsValue(k2);
            }

            @Override
            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Long2DoubleMap.Entry> i;
                    {
                        this.i = Long2DoubleMaps.fastIterator(AbstractLong2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Double> m2) {
        if (m2 instanceof Long2DoubleMap) {
            ObjectIterator<Long2DoubleMap.Entry> i2 = Long2DoubleMaps.fastIterator((Long2DoubleMap)m2);
            while (i2.hasNext()) {
                Long2DoubleMap.Entry e2 = (Long2DoubleMap.Entry)i2.next();
                this.put(e2.getLongKey(), e2.getDoubleValue());
            }
        } else {
            int n2 = m2.size();
            Iterator<Map.Entry<? extends Long, ? extends Double>> i3 = m2.entrySet().iterator();
            while (n2-- != 0) {
                Map.Entry<? extends Long, ? extends Double> e3 = i3.next();
                this.put(e3.getKey(), e3.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n2 = this.size();
        ObjectIterator<Long2DoubleMap.Entry> i2 = Long2DoubleMaps.fastIterator(this);
        while (n2-- != 0) {
            h2 += ((Long2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map m2 = (Map)o2;
        if (m2.size() != this.size()) {
            return false;
        }
        return this.long2DoubleEntrySet().containsAll(m2.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Long2DoubleMap.Entry> i2 = Long2DoubleMaps.fastIterator(this);
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Long2DoubleMap.Entry e2 = (Long2DoubleMap.Entry)i2.next();
            s2.append(String.valueOf(e2.getLongKey()));
            s2.append("=>");
            s2.append(String.valueOf(e2.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Long2DoubleMap.Entry> {
        protected final Long2DoubleMap map;

        public BasicEntrySet(Long2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2DoubleMap.Entry) {
                Long2DoubleMap.Entry e2 = (Long2DoubleMap.Entry)o2;
                long k2 = e2.getLongKey();
                return this.map.containsKey(k2) && Double.doubleToLongBits(this.map.get(k2)) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k3 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k3) && Double.doubleToLongBits(this.map.get(k3)) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2DoubleMap.Entry) {
                Long2DoubleMap.Entry e2 = (Long2DoubleMap.Entry)o2;
                return this.map.remove(e2.getLongKey(), e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            long k2 = (Long)key;
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v2 = (Double)value;
            return this.map.remove(k2, v2);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Long2DoubleMap.Entry {
        protected long key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Long key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if (o2 instanceof Long2DoubleMap.Entry) {
                Long2DoubleMap.Entry e2 = (Long2DoubleMap.Entry)o2;
                return this.key == e2.getLongKey() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e2.getDoubleValue());
            }
            Map.Entry e3 = (Map.Entry)o2;
            Object key = e3.getKey();
            if (key == null || !(key instanceof Long)) {
                return false;
            }
            Object value = e3.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.key == (Long)key && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

